<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Namespaces;

use OpenSearch\Endpoints\Observability\CreateObject;
use OpenSearch\Endpoints\Observability\DeleteObject;
use OpenSearch\Endpoints\Observability\DeleteObjects;
use OpenSearch\Endpoints\Observability\GetLocalstats;
use OpenSearch\Endpoints\Observability\GetObject;
use OpenSearch\Endpoints\Observability\ListObjects;
use OpenSearch\Endpoints\Observability\UpdateObject;

/**
 * Class ObservabilityNamespace
 *
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class ObservabilityNamespace extends AbstractNamespace
{
    /**
     * Creates a new observability object.
     *
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createObject(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(CreateObject::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Deletes specific observability object specified by ID.
     *
     * $params['object_id']   = (string) The ID of the observability object to delete.
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteObject(array $params = [])
    {
        $object_id = $this->extractArgument($params, 'object_id');

        $endpoint = $this->endpointFactory->getEndpoint(DeleteObject::class);
        $endpoint->setParams($params);
        $endpoint->setObjectId($object_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Deletes specific observability objects specified by ID or a list of IDs.
     *
     * $params['objectId']     = (string) The ID of a single observability object to delete.
     * $params['objectIdList'] = (string) A comma-separated list of observability object IDs to delete.
     * $params['pretty']       = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']        = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteObjects(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(DeleteObjects::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves local stats of all observability objects.
     *
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getLocalstats(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(GetLocalstats::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves specific observability object specified by ID.
     *
     * $params['object_id']   = (string) The ID of the observability object to retrieve.
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getObject(array $params = [])
    {
        $object_id = $this->extractArgument($params, 'object_id');

        $endpoint = $this->endpointFactory->getEndpoint(GetObject::class);
        $endpoint->setParams($params);
        $endpoint->setObjectId($object_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves list of all observability objects.
     *
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function listObjects(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(ListObjects::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Updates an existing observability object.
     *
     * $params['object_id']   = (string) The ID of the observability object to update.
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function updateObject(array $params = [])
    {
        $object_id = $this->extractArgument($params, 'object_id');
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(UpdateObject::class);
        $endpoint->setParams($params);
        $endpoint->setObjectId($object_id);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

}
