<?php
namespace WeltPixel\OwlCarouselSlider\Plugin\Framework\Image;

class AdapterPlugin
{
    /**
     * Add WebP support to image validation
     *
     * @param \Magento\Framework\Image\Adapter\AbstractAdapter $subject
     * @param callable $proceed
     * @param string $filename
     * @return bool
     */
    public function aroundValidateUploadFile(
        $subject,
        callable $proceed,
        $filename
    ) {
        try {
            if (pathinfo($filename, PATHINFO_EXTENSION) === 'webp') {
                if (!file_exists($filename)) {
                    throw new \Exception('File not found');
                }
                $imageInfo = getimagesize($filename);
                if ($imageInfo === false) {
                    throw new \Exception('Invalid image format');
                }
                // Check if GD supports WebP
                if (!function_exists('imagecreatefromwebp')) {
                    throw new \Exception('WebP support is not enabled in GD');
                }
                // Try to create image from WebP
                $image = imagecreatefromwebp($filename);
                if ($image === false) {
                    throw new \Exception('Invalid WebP image');
                }
                imagedestroy($image);
                return true;
            }
            return $proceed($filename);
        } catch (\Exception $e) {
            throw new \Exception('Unsupported image format: ' . $e->getMessage(), 0, $e);
        }
    }
}
