<?php

namespace BG\DesignHuddle\Plugin;

use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Sales\Api\Data\OrderSearchResultInterface;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Sales\Api\Data\OrderExtensionFactory;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Model\ResourceModel\Order\Collection;

class OrderApiPlugin
{
    /**
     * Init plugin
     *
     * @param OrderExtensionFactory $orderExtensionFactory
     */
    protected OrderExtensionFactory $orderExtensionFactory;


    public function __construct(
        OrderExtensionFactory $orderExtensionFactory
    ) {
        $this->orderExtensionFactory = $orderExtensionFactory;
    }


    public function afterGetList(
        OrderRepositoryInterface $subject,
        OrderSearchResultInterface $result,
        SearchCriteriaInterface $searchCriteria
    ){

        foreach ($result->getItems() as $order)
        {
            $this->setDesignData($order);
        }
        return $result;

    }


    public function afterGet(
        OrderRepositoryInterface $subject,
        \Magento\Sales\Api\Data\OrderInterface $resultOrder
    ) {

        $this->setDesignData($resultOrder);
        $resultOrder = $this->getShipmentItemTextAttribute($resultOrder);
        return $resultOrder;

    }

    public function setDesignData($resultOrder) {

        $items = $resultOrder->getAllItems();
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        foreach ($items as $item) {
            $extensionAttributes = $item->getExtensionAttributes();
            $designString = '';
            $BG = $objectManager->create('BG\DesignHuddle\Helper\Databgcollect');
            $data = $BG->getBgCollection($resultOrder->getId(),$item->getProductId());
            foreach ($data as $HDdataCols){
                $designString .= $HDdataCols->getDhProjectId().",";            }
            $extensionAttributes->setDesignId(rtrim($designString,","));
        }

    }

    /**
     * Add Shipment item level text attribute data
     * @param \Magento\Sales\Api\Data\OrderInterface $order
     * @return \Magento\Sales\Api\Data\OrderInterface
     */
    protected function getShipmentItemTextAttribute(\Magento\Sales\Api\Data\OrderInterface $order)
    {
        $shippingAssignments = $order->getExtensionAttributes()->getShippingAssignments();
        /** Since it is possible for more than one shipment to be created per order
         * we need to check for all possible shipments that may exist */
        if ($shippingAssignments){
        foreach ($shippingAssignments as $shippingAssignment) {
            $orderShipmentItems = $shippingAssignment->getItems();

            foreach ($orderShipmentItems as $orderShipmentItem) {
                $extensionAttributes = $order->getExtensionAttributes();
                /** getTextAttribute here is checking if your extension_attributes text_attribute exists */
                if ($extensionAttributes && $extensionAttributes->getTextAttribute()) {
                    continue;
                }

                try {
                  /** @var \Magento\Catalog\Model\Product $product */
                    $product = $orderShipmentItem->getProduct();
                    $textAttribute='123';
                } catch (NoSuchEntityException $e) {
                    continue;
                }

          /** @var \Magento\Sales\Api\Data\ShipmentItemExtension $shipmentItemExtension */
                $shipmentItemExtension = $extensionAttributes;
                //? $extensionAttributes
                //: $this->shipmentItemExtensionFactory->create();
                $shipmentItemExtension->setTextAttribute($textAttribute);
                $order->setExtensionAttributes($shipmentItemExtension);
            }
        }
    }
        return $order;
    }
}
