<?php
namespace BG\DesignHuddle\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Customer\Model\Session;
use Magento\Quote\Model\QuoteFactory;
use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Quote\Api\CartRepositoryInterface;

class CustomerLoginObserver implements ObserverInterface
{
    /**
     * @var Session
     */
    protected $customerSession;

    /**
     * @var CheckoutSession
     */
    private $checkoutSession;

    /**
     * @var QuoteFactory
     */
    protected $quoteFactory;
    /**
     * @var \Magento\Quote\Api\CartRepositoryInterface
     */
    protected $quoteRepository;

    public function __construct(Session $customerSession, 
            CheckoutSession $checkoutSession,
            QuoteFactory $quoteFactory,
            CartRepositoryInterface $quoteRepository
            )
    {
        $this->customerSession = $customerSession;
        $this->checkoutSession = $checkoutSession;
        $this->quoteFactory = $quoteFactory;
        $this->quoteRepository = $quoteRepository;
    }

    public function execute(Observer $observer)
    {
        $customer = $observer->getEvent()->getCustomer();
        $oldQuoteId = $this->customerSession->getQuoteId();
        $currentQuoteId = $this->customerSession->getCustomerId();

 
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $cart = $objectManager->get('\Magento\Checkout\Model\Cart');

        $quote = $cart->getQuote();
        $quoteId = $quote->getId();

        $getOldQuoteIdValue = $this->customerSession->getOldQuoteIdValue();

        $currQuoteId =  (int)$this->checkoutSession->getQuote()->getId(); 

        $customerId = $customer->getId();
        if($customerId){   
            $quoteId = $this->checkoutSession->getQuote()->getId();  
        } 

      //  If the old quote ID and the current quote ID are different, then update the quote
        if ($oldQuoteId && $oldQuoteId != $currentQuoteId) {
            $oldQuote = $this->quoteFactory->create()->load($oldQuoteId);
            $currentQuote = $this->quoteFactory->create()->load($currentQuoteId);
        }
    }
}
