<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Model\System\Config\Source\AdWords;

class Strategy implements \Magento\Framework\Data\OptionSourceInterface
{
	/**
	 * Standard implementation 
	 * 
	 * @var integer
	 */
	const ROAS = 1;
	
	/**
	 * Implementation using GTAG
	 * 
	 * @var integer
	 */
	const POAS = 2;

	/** 
	 * @var \Anowave\Ec\Helper\Data
	 */
	protected $helper;

	/**
	 * @return []
	 */
	public function toOptionArray()
	{
		$options = 
		[
			[
				'value' => static::ROAS,
				'label' => __('ROAS (Return On Ad Spend)')
			],
		    [
		        'value' => static::POAS,
		        'label' => __('POAS (Profit on Ad Spend)')
			]
		];
		
		return $options;
	}
}