<?php
/**
 *  Magento 2 Google Indexing API
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * http://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Indexing
 * @copyright 	Copyright (c) 2025 Anowave (http://www.anowave.com/)
 * @license  	http://www.anowave.com/license-agreement/
 */
 
namespace Anowave\Ec\Model;

use Anowave\Ec\Api\LogRepositoryInterface;
use Anowave\Ec\Model\ResourceModel\Log\CollectionFactory;

class LogRepository implements LogRepositoryInterface
{
    protected $logFactory;

    protected $logCollectionFactory;

    public function __construct
    (
        LogFactory $logFactory,
        CollectionFactory $logCollectionFactory
    )
    {
        $this->logFactory = $logFactory;
        $this->logCollectionFactory = $logCollectionFactory;
    }

    public function save(\Anowave\Ec\Api\Data\LogInterface $log)
    {
        $log->getResource()->save($log);

        return $log;
    }
}