<?php
/**
 * Copyright © 2017 MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\OptionVisibility\Model;

use Magento\Framework\Model\AbstractModel;

class OptionCustomerGroup extends AbstractModel
{
    public const TABLE_NAME = 'mageworx_optionvisibility_option_customer_group';
    public const OPTIONTEMPLATES_TABLE_NAME = 'mageworx_optiontemplates_group_option_customer_group';

    public const COLUMN_NAME_VISIBILITY_CUSTOMER_GROUP_ID = 'visibility_customer_group_id';
    public const COLUMN_NAME_OPTION_ID                    = 'option_id';
    public const COLUMN_NAME_GROUP_ID              = 'customer_group_id';

    public const KEY_CUSTOMER_GROUP = 'customer_group';
    public const FIELD_OPTION_ID_ALIAS = 'mageworx_customer_group_option_id';

    /**
     * Set resource model and Id field name
     *
     * @return void
     */
    protected function _construct()
    {
        parent::_construct();
        $this->_init('MageWorx\OptionVisibility\Model\ResourceModel\OptionCustomerGroup');
        $this->setIdFieldName('visibility_customer_group_id');
    }
}
