<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\OptionSwatches\Model;

use Magento\Catalog\Model\Product\Option;
use Magento\Framework\App\Area;
use Magento\Framework\App\State;
use MageWorx\OptionFeatures\Helper\Data as Helper;
use MageWorx\OptionSwatches\Model\ResourceModel\Catalog\ProductUrls;

class SkuLinkedProductsUrlProvider
{
    protected Helper $helper;

    protected State $state;

    protected ProductUrls $productUrls;

    protected array $loadLinkedProductLinks = [];

    public function __construct(
        Helper $helper,
        State $state,
        ProductUrls $productUrls
    ) {
        $this->helper      = $helper;
        $this->state       = $state;
        $this->productUrls = $productUrls;
    }

    /**
     * Load linked product urls for product options
     *
     * @param array $options
     * @return array
     */
    public function getSkuLinkedUrls(string $productSku, array $options): array
    {
        if (!array_key_exists($productSku, $this->loadLinkedProductLinks)) {
            $loadLinkedProductSkus  = [];
            $loadLinkedProductLinks = [];

            /** @var Option $option */
            foreach ($options as $option) {
                if (($option->getType() == Option::OPTION_TYPE_DROP_DOWN ||
                        $option->getType() == Option::OPTION_TYPE_MULTIPLE) &&
                    $this->state->getAreaCode() !== Area::AREA_ADMINHTML &&
                    $option->getIsSwatch()
                ) {
                    if ($this->helper->isLoadLinkedProductEnabled()) {
                        foreach ($option->getValues() as $value) {
                            $optionValueData = $value->getData();
                            $valueIsDefault  = $value->getIsDefault();
                            $skuIsValid      = isset($optionValueData['sku_is_valid']) ? $value->getSkuIsValid(
                            ) : false;

                            if ($value->getLoadLinkedProduct() && $skuIsValid && !$valueIsDefault) {
                                $loadLinkedProductSkus[] = $value->getSku();
                            }
                        }
                    }
                }
            }

            if ($loadLinkedProductSkus) {
                $loadLinkedProductLinks = $this->productUrls->getProductUrlsBySku($loadLinkedProductSkus);
            }

            $this->loadLinkedProductLinks[$productSku] = $loadLinkedProductLinks;
        }

        return $this->loadLinkedProductLinks[$productSku];
    }
}
