<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Namespaces;

use OpenSearch\Endpoints\SearchRelevance\DeleteExperiments;
use OpenSearch\Endpoints\SearchRelevance\DeleteJudgments;
use OpenSearch\Endpoints\SearchRelevance\DeleteQuerySets;
use OpenSearch\Endpoints\SearchRelevance\DeleteSearchConfigurations;
use OpenSearch\Endpoints\SearchRelevance\GetExperiments;
use OpenSearch\Endpoints\SearchRelevance\GetJudgments;
use OpenSearch\Endpoints\SearchRelevance\GetNodeStats;
use OpenSearch\Endpoints\SearchRelevance\GetQuerySets;
use OpenSearch\Endpoints\SearchRelevance\GetSearchConfigurations;
use OpenSearch\Endpoints\SearchRelevance\GetStats;
use OpenSearch\Endpoints\SearchRelevance\PostQuerySets;
use OpenSearch\Endpoints\SearchRelevance\PutExperiments;
use OpenSearch\Endpoints\SearchRelevance\PutJudgments;
use OpenSearch\Endpoints\SearchRelevance\PutQuerySets;
use OpenSearch\Endpoints\SearchRelevance\PutSearchConfigurations;

/**
 * Class SearchRelevanceNamespace
 *
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class SearchRelevanceNamespace extends AbstractNamespace
{
    /**
     * Deletes a specified experiment.
     *
     * $params['experiment_id'] = (string) The experiment id
     * $params['pretty']        = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']         = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace']   = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']        = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']   = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteExperiments(array $params = [])
    {
        $experiment_id = $this->extractArgument($params, 'experiment_id');

        $endpoint = $this->endpointFactory->getEndpoint(DeleteExperiments::class);
        $endpoint->setParams($params);
        $endpoint->setExperimentId($experiment_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Deletes a specified judgment.
     *
     * $params['judgment_id'] = (string) The judgment id
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteJudgments(array $params = [])
    {
        $judgment_id = $this->extractArgument($params, 'judgment_id');

        $endpoint = $this->endpointFactory->getEndpoint(DeleteJudgments::class);
        $endpoint->setParams($params);
        $endpoint->setJudgmentId($judgment_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Deletes a query set.
     *
     * $params['query_set_id'] = (string) The query set id
     * $params['pretty']       = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']        = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteQuerySets(array $params = [])
    {
        $query_set_id = $this->extractArgument($params, 'query_set_id');

        $endpoint = $this->endpointFactory->getEndpoint(DeleteQuerySets::class);
        $endpoint->setParams($params);
        $endpoint->setQuerySetId($query_set_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Deletes a specified search configuration.
     *
     * $params['search_configuration_id'] = (string) The search configuration id
     * $params['pretty']                  = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']                   = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteSearchConfigurations(array $params = [])
    {
        $search_configuration_id = $this->extractArgument($params, 'search_configuration_id');

        $endpoint = $this->endpointFactory->getEndpoint(DeleteSearchConfigurations::class);
        $endpoint->setParams($params);
        $endpoint->setSearchConfigurationId($search_configuration_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Gets experiments.
     *
     * $params['experiment_id'] = (string) The experiment id
     * $params['pretty']        = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']         = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace']   = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']        = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']   = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getExperiments(array $params = [])
    {
        $experiment_id = $this->extractArgument($params, 'experiment_id');

        $endpoint = $this->endpointFactory->getEndpoint(GetExperiments::class);
        $endpoint->setParams($params);
        $endpoint->setExperimentId($experiment_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Gets judgments.
     *
     * $params['judgment_id'] = (string) The judgment id
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getJudgments(array $params = [])
    {
        $judgment_id = $this->extractArgument($params, 'judgment_id');

        $endpoint = $this->endpointFactory->getEndpoint(GetJudgments::class);
        $endpoint->setParams($params);
        $endpoint->setJudgmentId($judgment_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Gets stats by node.
     *
     * $params['node_id']                  = (string) The node id (Required)
     * $params['stat']                     = (string) The statistic to return
     * $params['flat_stat_paths']          = (string) Requests flattened stat paths as keys
     * $params['include_all_nodes']        = (string) Whether to include all nodes
     * $params['include_individual_nodes'] = (string) Whether to include individual nodes
     * $params['include_info']             = (string) Whether to include info
     * $params['include_metadata']         = (string) Whether to include metadata
     * $params['pretty']                   = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']                    = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace']              = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                   = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']              = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getNodeStats(array $params = [])
    {
        $node_id = $this->extractArgument($params, 'node_id');
        $stat = $this->extractArgument($params, 'stat');

        $endpoint = $this->endpointFactory->getEndpoint(GetNodeStats::class);
        $endpoint->setParams($params);
        $endpoint->setNodeId($node_id);
        $endpoint->setStat($stat);

        return $this->performRequest($endpoint);
    }

    /**
     * Lists the current query sets available.
     *
     * $params['query_set_id'] = (string) The query set id
     * $params['pretty']       = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']        = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getQuerySets(array $params = [])
    {
        $query_set_id = $this->extractArgument($params, 'query_set_id');

        $endpoint = $this->endpointFactory->getEndpoint(GetQuerySets::class);
        $endpoint->setParams($params);
        $endpoint->setQuerySetId($query_set_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Gets the search configurations.
     *
     * $params['search_configuration_id'] = (string) The search configuration id
     * $params['pretty']                  = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']                   = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getSearchConfigurations(array $params = [])
    {
        $search_configuration_id = $this->extractArgument($params, 'search_configuration_id');

        $endpoint = $this->endpointFactory->getEndpoint(GetSearchConfigurations::class);
        $endpoint->setParams($params);
        $endpoint->setSearchConfigurationId($search_configuration_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Gets stats.
     *
     * $params['stat']                     = (string) The statistic to return
     * $params['flat_stat_paths']          = (string) Requests flattened stat paths as keys
     * $params['include_all_nodes']        = (string) Whether to include all nodes
     * $params['include_individual_nodes'] = (string) Whether to include individual nodes
     * $params['include_info']             = (string) Whether to include info
     * $params['include_metadata']         = (string) Whether to include metadata
     * $params['pretty']                   = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']                    = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace']              = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                   = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']              = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getStats(array $params = [])
    {
        $stat = $this->extractArgument($params, 'stat');

        $endpoint = $this->endpointFactory->getEndpoint(GetStats::class);
        $endpoint->setParams($params);
        $endpoint->setStat($stat);

        return $this->performRequest($endpoint);
    }

    /**
     * Creates a new query set by sampling queries from the user behavior data.
     *
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function postQuerySets(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(PostQuerySets::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Creates an experiment.
     *
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function putExperiments(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(PutExperiments::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Creates a judgment.
     *
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function putJudgments(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(PutJudgments::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Creates a new query set by uploading manually.
     *
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function putQuerySets(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(PutQuerySets::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Creates a search configuration.
     *
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function putSearchConfigurations(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(PutSearchConfigurations::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

}
