<?php
namespace WeltPixel\OwlCarouselSlider\Plugin\Framework\Data\Form\Element;

class ImagePlugin
{
    /**
     * Handle file path conversion
     *
     * @param \Magento\Framework\Data\Form\Element\Image $subject
     * @param mixed $result
     * @return string
     */
    public function afterGetValue(
        \Magento\Framework\Data\Form\Element\Image $subject,
        $result
    ) {
        if (is_array($result)) {
            return isset($result['value']) ? $result['value'] : '';
        }
        return $result;
    }

    /**
     * Handle file path conversion before getting HTML
     *
     * @param \Magento\Framework\Data\Form\Element\Image $subject
     * @param callable $proceed
     * @return string
     */
    public function aroundGetElementHtml(
        \Magento\Framework\Data\Form\Element\Image $subject,
        callable $proceed
    ) {
        $value = $subject->getValue();
        if (is_array($value)) {
            $subject->setValue(isset($value['value']) ? $value['value'] : '');
        }
        return $proceed();
    }
} 