<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Observer\Sales\Quote\Address;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Magento\Quote\Model\Quote\Address;
use Magento\Quote\Model\Quote\Address\Rate;
use Magento\Quote\Model\Shipping;
use Magento\Quote\Model\ShippingAssignment;

class CollectTotalsAfter implements ObserverInterface
{

    /**
     * Remove disabled shipping methods from collection
     *
     * @param Observer $observer
     * @return $this
     */
    public function execute(Observer $observer)
    {

        $event = $observer->getEvent();

        /** @var ShippingAssignment $shippingAssignment */
        $shippingAssignment = $event->getShippingAssignment();
        /** @var Shipping $shipping */
        $shipping = $shippingAssignment->getShipping();
        /** @var Address $shippingAddress */
        $shippingAddress = $shipping->getAddress();
        /** @var array of \Magento\Quote\Model\Quote\Address\Rate\Interceptor $rates */
        $rates = $shippingAddress->getAllShippingRates();
        /** @var AbstractCollection $ratesCollection */
        $ratesCollection = $shippingAddress->getShippingRatesCollection();
        /** @var array $disabledShippingMethods */
        $disabledShippingMethods = $shippingAddress->getDisabledShippingMethods();

        if (!$disabledShippingMethods) {
            return $this;
        }

        /** @var Rate $rate */
        foreach ($rates as $rate) {
            /** @var string like "carrier_method" $code */
            $code = $rate->getCode();
            if (!isset($disabledShippingMethods[$code])) {
                continue;
            }

            if (!$disabledShippingMethods[$code]) {
                $ratesCollection->removeItemByKey($rate->getId());
            }
        }

        return $this;
    }
}
