<?php

namespace MageWorx\ShippingRules\Model\Carrier;

use Magento\Framework\Registry;
use Magento\Ui\DataProvider\AbstractDataProvider;
use MageWorx\ShippingRules\Model\Carrier;
use MageWorx\ShippingRules\Model\ResourceModel\Carrier\Collection;
use MageWorx\ShippingRules\Model\ResourceModel\Carrier\CollectionFactory;

class DataProvider extends AbstractDataProvider
{
    /**
     * @var array
     */
    protected $loadedData;

    /**
     * Core registry
     *
     * @var Registry
     */
    protected $coreRegistry = null;

    /**
     * Constructor
     *
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param Registry $coreRegistry
     * @param CollectionFactory $collectionFactory
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        Registry $coreRegistry,
        CollectionFactory $collectionFactory,
        array $meta = [],
        array $data = []
    ) {
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
        $this->coreRegistry = $coreRegistry;
        /** @var Collection collection */
        $this->collection = $collectionFactory->create();
    }

    /**
     * Get data
     *
     * @return array
     */
    public function getData()
    {
        if (isset($this->loadedData)) {
            return $this->loadedData;
        }

        /** @var Carrier $carrier */
        $carrier = $this->coreRegistry->registry('current_carrier');
        if (!empty($carrier)) {
            $carrierId                    = $carrier->getId();
            $this->loadedData[$carrierId] = $carrier->getData();
        }

        return $this->loadedData;
    }
}
