<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Block\Adminhtml\Shippingrules\ExtendedZone\Edit\Button;

class Back extends Generic
{
    /**
     * Get back button data
     *
     * @param int $sortOrder
     * @return array
     */
    public function getButtonData($sortOrder = 10)
    {
        $url     = $this->getUrl('*/*/');
        $label   = __('Back');
        $onClick = sprintf("location.href = '%s';", $url);
        $result  = [
            'label'      => $label,
            'on_click'   => $onClick,
            'class'      => 'back',
            'sort_order' => $sortOrder
        ];

        return $result;
    }
}
