<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Api;

use Magento\Framework\DataObject;
use Magento\Quote\Model\Quote\Address\Rate;
use Magento\Quote\Model\Quote\Address\RateResult\Method;

interface RuleEntityInterface
{
    /**
     * Get store specific error message
     *
     * @param Method|Rate $rate
     * @param null $storeId
     * @return mixed
     */
    public function getStoreSpecificErrorMessage(
        DataObject $rate,
                   $storeId = null
    );
}
