<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Api;

use Exception;
use Magento\Framework\Exception\LocalizedException;

interface ImportHandlerInterface
{
    /**
     * Import Carriers, Methods, Rates from CSV file
     *
     * @param mixed[] $file file info retrieved from $_FILES array
     * @param mixed[] $entities
     * @return void
     * @throws LocalizedException
     * @throws Exception
     */
    public function importFromCsvFile($file, $entities = []);
}
