/**
 * Copyright © MageWorx, Inc. All rights reserved.
 * See LICENSE.txt for license details.
 */
define([
    'jquery',
    'uiComponent',
    'ko',
    'MageWorx_ShippingCalculatorBase/js/action/generate-method',
    'uiRegistry',
    'underscore',
    'mage/translate'
], function ($, Component, ko, methodsGenerator, registry, _, $t) {
    'use strict';

    return Component.extend({
        defaults: {
            visible: false,
            productFormChanged: false,
            changeLocationLabel: $t('Change my location'),
            refreshFormLabel: $t('Refresh'),
            methods: {},
            cheapestPrice: Infinity,
            displayCheapestPrice: false
        },

        /**
         * Properties which will be set as an observable during initObservable method call
         */
        observableProperties: [
            'visible',
            'changeLocationLabel',
            'productFormChanged',
            'methods',
            'cheapestPrice',
            'displayCheapestPrice'
        ],

        /**
         * Initialize observables properties
         *
         * @returns {exports}
         */
        initObservable: function () {
            this._super();
            this.observe(this.observableProperties);
            this.productFormChanged(false);

            var self = this,
                $productForm = $('#product_addtocart_form');
            $productForm.find(':input').change(function() {
                self.productFormChanged(true);
            });

            this.initSubscriptions();

            return this;
        },

        /**
         * Init subsriptions
         */
        initSubscriptions: function () {
            var self = this;
            this.methods.subscribe(function (value) {
                self.cheapestPrice(Infinity);
                for (var key in value) {
                    if (value.hasOwnProperty(key)) {
                        var method = value[key];
                        self.generateNewMethod(method);
                        if (method['price'] <= self.cheapestPrice()) {
                            self.cheapestPrice(method['price']);
                        }
                    }
                }

                if (!_.isEmpty(value)) {
                    self.visible(true);
                }
            });
        },

        /**
         * Add new shipping methods information child to the methods list
         * Using from console:
         * ```
         * require('uiRegistry')
         *      .get('index = methods-list')
         *      .generateNewMethod(
         *          {
         *              name: 'unique_name',
         *              template: 'MageWorx_ShippingCalculatorBase/view/methods/method'
         *          }
         *      )
         * ```
         */
        generateNewMethod: function (options) {
            methodsGenerator(this, options);
        },

        showForm: function () {
            var form = registry.get('index = estimateForm');

            if (form) {
                this.visible(false);
                form.visible(true);
            }
        },

        refreshForm: function () {
            var form = registry.get('index = estimateForm');

            if (form) {
                form.estimateShippingMethods();
            }
        }
    });
});
