/**
 * Copyright © MageWorx, Inc. All rights reserved.
 * See LICENSE.txt for license details.
 */
define([
    'underscore',
    'uiRegistry',
    'Magento_Ui/js/form/element/post-code',
    'Magento_Checkout/js/model/postcode-validator',
    'mage/translate'
], function (_, registry, PostCode, postCodeValidator, $t) {
    'use strict';

    return PostCode.extend({
        defaults: {
            skipValidation: false
        },

        /**
         * Properties which will be set as an observable during initObservable method call
         */
        observableProperties: [
            'additionalClasses',
            'required'
        ],

        /**
         * Initialize observables properties
         *
         * @returns {exports}
         */
        initObservable: function () {
            this._super();
            this.observe(this.observableProperties);

            return this;
        },

        /**
         * Validates itself by it's validation rules using validator object.
         * If validation of a rule did not pass, writes it's message to
         * 'error' observable property.
         *
         * @returns {Object} Validate information.
         */
        validate: function () {
            var country = registry.get(this.parentName + '.' + 'country_id'),
                region = registry.get(this.parentName + '.' + 'region'),
                regionId = registry.get(this.parentName + '.' + 'region_id'),
                regionIdCustomInput = registry.get(this.parentName + '.' + 'region_id_input'),
                countryVisible = country && country.visible(),
                regionVisible = (region && region.visible())
                    || (regionId && regionId.visible())
                    || (regionIdCustomInput && regionIdCustomInput.visible());
            if (!this.required() && !this.value() && (countryVisible || regionVisible)) {
                // not required in case country or region field visible
                return {
                    valid: true,
                    target: this
                };
            }

            if (!this.visible()) {
                return {
                    valid: true,
                    target: this
                };
            }

            var result = this._super();

            if (!country) {
                return result;
            }

            var options = country.indexedOptions,
                option,
                value = this.value(),
                countryId = country.value();

            if (!value) {
                return result;
            }

            option = options[countryId];
            if (!option) {
                return result;
            }

            var patterns = window.checkoutConfig.postCodes;
            if (!patterns) {
                return result;
            }

            var pattern = patterns[countryId];
            if (!pattern) {
                return result;
            }

            var zipValidationByPattern = postCodeValidator.validate(value, countryId, patterns);

            result['valid'] = result['valid'] && zipValidationByPattern;
            if (!zipValidationByPattern) {
                this.source.set('params.invalid', true);
                var example = '';
                _.each(pattern, function (obj) {
                    example += ' ' + obj.example + ';'
                });

                this.error($t('Zip Code invalid. Valid Zip Code Example: %1').replace('%1', example));
            }

            return result;
        }
    });
});
