/**
 * Copyright © MageWorx, Inc. All rights reserved.
 * See LICENSE.txt for license details.
 */
define([
    'jquery',
    'uiComponent',
    'ko',
    'mage/translate'
], function ($, Component, ko, $t) {
    'use strict';

    return Component.extend({
        defaults: {
            description: $t("Update shipping information to see available shipping methods:"),
            imports: {
                visible: 'shipping-calculator.estimateForm:visible'
            }
        },

        /**
         * Properties which will be set as an observable during initObservable method call
         */
        observableProperties: [
            'description',
            'visible'
        ],

        /**
         * Initialize observables properties
         *
         * @returns {exports}
         */
        initObservable: function () {
            this._super();
            this.observe(this.observableProperties);

            return this;
        }
    });
});
