<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingCalculatorBase\Api;

use Magento\Framework\Exception\LocalizedException;

/**
 * Interface EstimateShippingMethodsInterface
 */
interface EstimateShippingMethodsInterface
{
    const QUOTE_SAVE_DISABLED_FLAG = 'mageworx_calculator_save_disabled_flag';

    /**
     * Estimate shipping methods
     *
     * @param array $addressData
     * @param array $itemData
     * @return array
     * @throws LocalizedException
     */
    public function estimate(array $addressData, array $itemData): array;
}
