<?php
/**
 * Copyright © 2016 MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\OptionFeatures\Model;

use Magento\Catalog\Model\Product;
use Magento\Framework\Model\AbstractExtensibleModel;

class OptionTypeDescription extends AbstractExtensibleModel
{
    public const TABLE_NAME = 'mageworx_optionfeatures_option_type_description';
    public const OPTIONTEMPLATES_TABLE_NAME = 'mageworx_optiontemplates_group_option_type_description';

    public const COLUMN_NAME_OPTION_TYPE_DESCRIPTION_ID = 'option_type_description_id';
    public const COLUMN_NAME_OPTION_TYPE_ID             = 'option_type_id';
    public const COLUMN_NAME_STORE_ID            = 'store_id';
    public const COLUMN_NAME_DESCRIPTION = 'description';

    public const FIELD_OPTION_TYPE_ID_ALIAS = 'mageworx_description_option_type_id';

    /**
     * Set resource model and Id field name
     *
     * @return void
     */
    protected function _construct()
    {
        parent::_construct();
        $this->_init('MageWorx\OptionFeatures\Model\ResourceModel\OptionTypeDescription');
        $this->setIdFieldName(self::COLUMN_NAME_OPTION_TYPE_DESCRIPTION_ID);
    }
}
