<?php
declare(strict_types = 1);

namespace MageWorx\OptionBase\Test\Unit\Plugin;

use Magento\Catalog\Model\ResourceModel\Product\Option\Collection;
use Magento\Catalog\Model\ResourceModel\Product\Option\Value\Collection as ValueCollection;
use Magento\Catalog\Model\ResourceModel\Product\Option\Value\CollectionFactory;
use Magento\Framework\App\State;
use Magento\Framework\Event\ManagerInterface;
use Magento\Framework\Serialize\Serializer\Json;
use Magento\Store\Model\StoreManagerInterface;
use MageWorx\OptionBase\Helper\Data as BaseHelper;
use MageWorx\OptionBase\Helper\System as SystemHelper;
use MageWorx\OptionBase\Model\ConditionValidator;
use MageWorx\OptionBase\Model\ResourceModel\CollectionUpdaterRegistry;
use MageWorx\OptionBase\Plugin\CollectProductOptionConditions;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class CollectProductOptionConditionsTest extends TestCase
{
    private CollectProductOptionConditions $plugin;
    private MockObject                     $collectionUpdaterRegistry;
    private MockObject                     $optionValueCollectionFactory;
    private MockObject                     $systemHelper;
    private MockObject                     $storeManager;
    private MockObject                     $state;
    private MockObject                     $serializer;
    private MockObject                     $conditionValidator;
    private MockObject                     $eventManager;
    private MockObject                     $baseHelper;

    protected function setUp(): void
    {
        $this->collectionUpdaterRegistry    = $this->createMock(CollectionUpdaterRegistry::class);
        $this->optionValueCollectionFactory = $this->createMock(CollectionFactory::class);
        $this->systemHelper                 = $this->createMock(SystemHelper::class);
        $this->storeManager                 = $this->createMock(StoreManagerInterface::class);
        $this->state                        = $this->createMock(State::class);
        $this->serializer                   = $this->createMock(Json::class);
        $this->conditionValidator           = $this->createMock(ConditionValidator::class);
        $this->eventManager                 = $this->createMock(ManagerInterface::class);
        $this->baseHelper                   = $this->createMock(BaseHelper::class);

        $this->plugin = new CollectProductOptionConditions(
            $this->collectionUpdaterRegistry,
            $this->optionValueCollectionFactory,
            $this->systemHelper,
            $this->storeManager,
            $this->state,
            $this->serializer,
            $this->conditionValidator,
            $this->eventManager,
            $this->baseHelper
        );
    }

    public function testAroundAddValuesToResult(): void
    {
        $collection      = $this->createMock(Collection::class);
        $valueCollection = $this->createMock(ValueCollection::class);

        $storeMock = $this->createConfiguredMock(
            \Magento\Store\Api\Data\StoreInterface::class, [
                                                             'getId' => 1
                                                         ]
        );
        $this->storeManager->method('getStore')->willReturn($storeMock);

        $optionMock = $this->createConfiguredMock(
            \Magento\Catalog\Model\Product\Option::class, [
                                                            'getId' => 123
                                                        ]
        );
        $collection->method('getIterator')->willReturn(new \ArrayIterator([$optionMock]));

        $valueMock = $this->getMockBuilder(\Magento\Catalog\Model\Product\Option\Value::class)
                          ->addMethods(['getOptionId'])
                          ->onlyMethods(['getOptionTypeId', 'getSortOrder', 'getTitle', 'setOption'])
                          ->disableOriginalConstructor()
                          ->getMock();

        $valueMock->method('getOptionTypeId')->willReturn(456);
        $valueMock->method('getOptionId')->willReturn(123);
        $valueMock->method('getSortOrder')->willReturn(1);
        $valueMock->method('getTitle')->willReturn('Test Title');

        $this->optionValueCollectionFactory
            ->method('create')
            ->willReturn($valueCollection);

        $valueCollection->method('addTitleToResult')->willReturnSelf();
        $valueCollection->method('addPriceToResult')->willReturnSelf();
        $valueCollection->method('addOptionToFilter')->willReturnSelf();
        $valueCollection->method('getIterator')->willReturn(new \ArrayIterator([$valueMock]));

        $this->state->method('getAreaCode')->willReturn('graphql');
        $this->systemHelper->method('resolveCurrentCustomerGroupId')->willReturn(1);
        $this->conditionValidator->method('isValidated')->willReturn(true);
        $this->serializer->method('unserialize')->willReturn([]);
        $this->serializer->method('serialize')->willReturn('{}');

        $this->baseHelper->method('isModuleEnabled')->willReturn(false);

        $optionMock->expects($this->once())->method('addValue');
        $valueMock->expects($this->once())->method('setOption');

        $closure = fn() => $collection;

        $result = $this->plugin->aroundAddValuesToResult($collection, $closure);
        $this->assertSame($collection, $result);
    }
}
