<?php
/**
 * Magento 2 Google Analytics 4 for Magento 2
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * http://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (http://www.anowave.com/)
 * @license  	http://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec4\Plugin;

class Response
{
    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    /**
     * Constructor
     */
    public function __construct
    (
        \Psr\Log\LoggerInterface $logger
    )
    {
        $this->logger = $logger;
    }

    public function beforeSendHeaders(\Laminas\Http\PhpEnvironment\Response $response)
    {
        $headers = [];

        foreach ($response->getHeaders() as $header) 
        {
            

            if ($header instanceof MultipleHeaderInterface) {
                
                $header[] = $header->toString();

                continue;
            }
            $headers[] = $header->toString();
        }

        $size = 0;

        foreach($headers as $header)
        {
            if (false !== strpos($header, 'Content-Security-Policy'))
            {
                $size += strlen($header);
            }
        }

        if (8 <= $size/1024)
        {
            $this->logger->debug('Content-Security-Policy headers are in excess of 8KB');
        };
        

        return null;
    }
}