<?php
/**
 * Magento 2 Google Analytics 4 for Magento 2 GA4
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * http://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec4
 * @copyright 	Copyright (c) 2025 Anowave (http://www.anowave.com/)
 * @license  	http://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec4\Block;

use Anowave\Ec\Model\Cookie\Asses;
use Anowave\Ec\Helper\Data;
use Anowave\Ec\Helper\Datalayer;
use Anowave\Ec\Model\Api\Measurement\Protocol;
use Anowave\Ec\Helper\Affiliation;
use Magento\Framework\View\Element\Template\Context;
use Magento\Directory\Model\CurrencyFactory;
use Magento\Framework\Registry;
use Magento\Framework\Filesystem\Driver\File;
use Psr\Log\LoggerInterface;

class Track extends \Anowave\Ec\Block\Track
{
    /**
     * @var \Magento\Framework\Registry
     */
    protected $registry;
    
    /**
     * @var \Anowave\Ec\Helper\Affiliation $affiliation
     */
    protected $affiliation;
    
    /**
     * Constructor 
     * 
     * @param Context $context
     * @param Data $helper
     * @param Datalayer $dataLayer
     * @param Protocol $protocol
     * @param CurrencyFactory $currencyFactory
     * @param Registry $registry
     * @param Affiliation $affiliation
     * @param File $driverFile
     * @param LoggerInterface $logger
     * @param array $data
     */
    public function __construct
    (
        Context $context,
        Data $helper,
        Datalayer $dataLayer,
        Protocol $protocol,
        CurrencyFactory $currencyFactory,
        Registry $registry,
        Affiliation $affiliation,
        File $driverFile,
        LoggerInterface $logger,
        Asses $asses,
        array $data = []
    )
    {
        $this->registry = $registry;
        $this->affiliation = $affiliation;
        
        parent::__construct($context, $helper, $dataLayer, $protocol, $currencyFactory, $driverFile, $logger, $asses);
    }
    
    public function getViewCart() : string
    {
        $checkout = $this->getHelper()->getCheckoutProducts($this, $this->registry);
        
        $payload = 
        [
            'event' => 'view_cart',
            'ecommerce' => 
            [
                'currency' => $this->getHelper()->getCurrency(),
                'value' => 0,
                'items' => []
            ]
        ];
        
        /**
         * Cart value
         * 
         * @var integer $value
         */
        $value = 0;
        
        /**
         * Item array 
         * 
         * @var array $items
         */
        $items = [];
        
        /**
         * Default starting position
         * 
         * @var integer $index
         */
        $index = 1;
        
        foreach ($checkout->products as $product)
        {
            $item = $product;
            
            foreach ($this->getItemCategories($product['category']) as $key => $category)
            {
                $item[$key] = $category;
            }
            
            $items[] = $item;
            
            $value += ((float) $item['price'] * (float) $product['quantity']);
        }

        $value = $this->getHelper()->getAmount($value);


        /**
         * Set value
         */
        $payload['ecommerce']['value'] = $value;
        
        /**
         * Set items
         */
        $payload['ecommerce']['items'] = $items;
        
        /**
         * Create transport object
         *
         * @var \Magento\Framework\DataObject $transport
         */
        $transport = new \Magento\Framework\DataObject
        (
            [
                'payload' => $payload
            ]
        );
        
        /**
         * Notify others for schema
         */
        $this->getHelper()->getEventManager()->dispatch('ec_view_cart', ['transport' => $transport]);
        
        /**
         * Update payload
         */
        $payload = $transport->getPayload();

        return $this->getHelper()->getJsonHelper()->encode($payload);
    }
    
    /**
     * Get cateiory map 
     * 
     * @param string $category
     * @return array
     */
    protected function getItemCategories($category) : array
    {
        $map = [];
        
        $categories = explode(chr(47), (string) $category);
        
        $map['item_category'] = array_shift($categories);
        
        if ($categories)
        {
            $index = 1;
            
            foreach ($categories as $category)
            {
                $map['item_category' . (++$index)] = $category;
            }
        }
        
        return $map;
    }
    
}