<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Plugin\Block\Adminhtml\Order;

use Magento\Sales\Block\Adminhtml\Order\View as ViewBlock;
use Anowave\Ec\Helper\Data;

class View
{
    protected $helper;

    /**
     * Constructor
     */
    public function __construct
    (
        Data $helper
    )
    {
        $this->helper = $helper;    
    }

    public function beforeSetLayout(ViewBlock $view)
    {
        $config = json_encode
        (
            [
                'order_id' => $view->getOrderId()
            ]
        );
        
        if ($this->helper->isGoogleAdsApiEnabled())
        {
            $view->addButton
            (
                'conversion_enhancement',
                [
                    'label'         => __('Enhance'),
                    'class'         => '',
                    'on_click'  	=> sprintf('require("adjustment").enhancement(%s)', $config),
                    'after_html'    => '<script>require(["adjustment"], function(adjustment) {})</script>'
                ]
            );

            $view->addButton
            (
                'conversion_adjustment',
                [
                    'label'         => __('Adjust'),
                    'class'         => '',
                    'on_click'  	=> sprintf('require("adjustment").adjustment(%s)', $config),
                    'after_html'    => '<script>require(["adjustment"], function(adjustment) {})</script>'
                ]
            );
        } 
    }
}