<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Model\System\Config\Source;

class Currency implements \Magento\Framework\Data\OptionSourceInterface
{
    const AUTO = 'auto';

    /**
     * @var \Magento\Directory\Model\Currency
     */
    protected $currencyModel;

    /**
     * Constructor
     * 
     * @param \Magento\Directory\Model\Currency $currencyModel
     */
    public function __construct(\Magento\Directory\Model\Currency $currencyModel)
    {
        $this->currencyModel = $currencyModel;
    }

	/**
	 * @return []
	 */
	public function toOptionArray()
    {
        $options = 
        [
            [
                'value' => static::AUTO, 
                'label' => __('Use current store currency (auto, recommended)')
            ]
        ];

        foreach($this->currencyModel->getConfigAllowCurrencies() as $currency)
        {
            $options[] = 
            [
                'value' => $currency, 
                'label' => __('Convert to ') . $currency
            ];
        }

        return $options;
	}
}