<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Model;

use Magento\Framework\Model\AbstractModel;
use Anowave\Ec\Api\Data\QueueInterface;

class Queue extends AbstractModel implements QueueInterface
{
	protected function _construct()
	{
	    $this->_init(\Anowave\Ec\Model\ResourceModel\Queue::class);
	}

    public function setQueueOrderId(string $order_id = '')
    {
        $this->setData('queue_order_id', $order_id);
    }

    public function setQueueStatusId(int $status_id = 0)
    {
        $this->setData('queue_status_id', $status_id);
    }

    public function setQueueUpdatedAt(string $time = '')
    {
        $this->setData('queue_updated_at', $time);
    }
}