<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Helper;

use Magento\Framework\App\ProductMetadataInterface;

class Bridge
{
	/**
	 * @var ProductMetadataInterface
	 */
	protected $productMetadata;
	
	/**
	 * Constructor 
	 * 
	 * @param ProductMetadataInterface $productMetadata
	 * @param array $data
	 */
	public function __construct
	(
		ProductMetadataInterface $productMetadata,
		array $data = []
	)
	{
		$this->productMetadata = $productMetadata;
	}
	/**
	 * Bridge between CE and EE (2.x)
	 * 
	 * @param \Magento\Catalog\Block\Product\AbstractProduct $block
	 */
	public function getLoadedItems($block)
	{	
		/**
		 * Try to get loaded items
		 * 
		 * @var [] $items
		 */
		$items = $block->getLoadedItems();
		
		/**
		 * Check items. They could be null in Magento EE
		 */
		if (!$items)
		{
			$items = $block->getAllItems();	
		}
		
		if ($items)
		{
			return $items;
		}
		
		return [];
	}
	
	public function getVersion()
	{
		return $this->productMetadata->getVersion();
	}
}