<?php
/**
 *  Magento 2 Google Indexing API
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * http://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Indexing
 * @copyright 	Copyright (c) 2025 Anowave (http://www.anowave.com/)
 * @license  	http://www.anowave.com/license-agreement/
 */
 
namespace Anowave\Ec\Model;

use Anowave\Ec\Api\QueueRepositoryInterface;
use Anowave\Ec\Model\ResourceModel\Queue\CollectionFactory;

class QueueRepository implements QueueRepositoryInterface
{
    protected $queueFactory;

    protected $queueCollectionFactory;

    public function __construct
    (
        QueueFactory $queueFactory,
        CollectionFactory $queueCollectionFactory
    )
    {
        $this->queueFactory = $queueFactory;
        $this->queueCollectionFactory = $queueCollectionFactory;
    }

    /**
     * Get by id
     * 
     * @param int $id
     * 
     * @return [type]
     */
    public function getById(int $id = 0)
    {
        $queue = $this->queueFactory->create()->load($id);

        if (!$queue->getQueueId()) 
        {
            throw new \Magento\Framework\Exception\NoSuchEntityException();
        }

        return $queue;
    }

    public function save(\Anowave\Ec\Api\Data\QueueInterface $queue)
    {
        $queue->getResource()->save($queue);

        return $queue;
    }
}