<?php
/**
 * Created by Magenest JSC.
 * Author: Jacob
 * Date: 18/01/2019
 * Time: 9:41
 */

namespace Magenest\SagepayLib\Classes;


/**
 * The Sage Pay Direct integration method API
 */
class SagepayDirectApi extends SagepayAbstractApi
{

    /**
     * The Server URL for integration methods
     *
     * @var string
     */
    private $_vpsDirectUrl;

    /**
     * Integration method
     *
     * @var string
     */
    protected $integrationMethod = Constants::SAGEPAY_DIRECT;

    /**
     * Constructor for SagepayDirectApi
     *
     * @param SagepaySettings $config
     */
    public function __construct(SagepaySettings $config)
    {
        parent::__construct($config);
        $this->_vpsDirectUrl = $config->getPurchaseUrl('direct');
        $this->mandatory = array(
            'VPSProtocol',
            'TxType',
            'Vendor',
            'VendorTxCode',
            'Amount',
            'Currency',
            'Description',
            'CardHolder',
            'CardNumber',
            'ExpiryDate',
            'CardType',
            'BillingSurname',
            'BillingFirstnames',
            'BillingAddress1',
            'BillingCity',
            'BillingPostCode',
            'BillingCountry',
            'DeliverySurname',
            'DeliveryFirstnames',
            'DeliveryAddress1',
            'DeliveryCity',
            'DeliveryPostCode',
            'DeliveryCountry',
            'BrowserJavascriptEnabled',
            'BrowserAcceptHeader',
            'BrowserLanguage',
            'BrowserUserAgent',
            'ThreeDSNotificationURL',
            'ChallengeWindowSize',
            'TransType'
        );
    }

    /**
     * Generate values for payment.
     * Ensure that post data is setted to request with SagepayAbstractApi::setData()
     *
     * @return array The response from Sage Pay
     * @throws SagepayApiException
     * @see SagepayAbstractApi::createRequest()
     */
    public function createRequest()
    {
        $this->data = SagepayCommon::encryptedOrder($this);
        $this->addConfiguredValues();
        $this->checkMandatoryFields();

        $ttl = $this->config->getRequestTimeout();
        $caCert = $this->config->getCaCertPath();
        return SagepayCommon::requestPost($this->_vpsDirectUrl, $this->data, $ttl, $caCert);
    }

    /**
     * Set integrationMethod
     *
     * @param string $integrationMethod
     */
    public function setIntegrationMethod($integrationMethod)
    {
        if (in_array($integrationMethod, array(Constants::SAGEPAY_DIRECT, Constants::SAGEPAY_PAYPAL, Constants::SAGEPAY_TOKEN)))
        {
            $this->integrationMethod = $integrationMethod;
        }
    }

    /**
     * @see SagepayAbstractApi::getQueryData()
     * @return null
     */
    public function getQueryData()
    {
        return null;
    }

    /**
     * Get vpsDirectUrl
     *
     * @return string
     */
    public function getVpsDirectUrl()
    {
        return $this->_vpsDirectUrl;
    }

    /**
     * Set vpsDirectUrl
     *
     * @uses SagepayValid::url Validate URL field
     * @param string $vpsDirectUrl
     */
    public function setVpsDirectUrl($vpsDirectUrl)
    {
        if (SagepayValid::url($vpsDirectUrl))
        {
            $this->_vpsDirectUrl = $vpsDirectUrl;
        }
    }

    protected function checkMandatoryFields()
    {
        foreach ($this->data as $key => $ele) {
            if ( $ele === '') {
                unset($this->data[$key]);
            }
        }
        parent::checkMandatoryFields(); // TODO: Change the autogenerated stub
    }
}

