<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

declare(strict_types=1);

namespace Magento\AdobeStockClient\Model\SearchParametersProvider;

use AdobeStock\Api\Models\SearchParameters;
use Magento\AdobeStockClient\Model\SearchParameterProviderInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

/**
 * Defines if offensive images should be excluded from the search results
 */
class Offensive implements SearchParameterProviderInterface
{
    private const OFFENSIVE_FILTER = 'offensive_filter';
    private const DISABLED = 'Disabled';

    /**
     * @inheritdoc
     */
    public function apply(SearchCriteriaInterface $searchCriteria, SearchParameters $searchParams): SearchParameters
    {
        foreach ($searchCriteria->getFilterGroups() as $filterGroup) {
            foreach ($filterGroup->getFilters() as $filter) {
                if ($filter->getField() === self::OFFENSIVE_FILTER && $filter->getValue() === self::DISABLED) {
                    $searchParams->setFilterOffensive2(true);
                    break;
                }
            }
        }
        return $searchParams;
    }
}
