<?php
namespace Magento\Sales\Api\Data;

/**
 * ExtensionInterface class for @see \Magento\Sales\Api\Data\OrderAddressInterface
 */
interface OrderAddressExtensionInterface extends \Magento\Framework\Api\ExtensionAttributesInterface
{
    /**
     * @return string|null
     */
    public function getDeliveryDay();

    /**
     * @param string $deliveryDay
     * @return $this
     */
    public function setDeliveryDay($deliveryDay);

    /**
     * @return string|null
     */
    public function getDeliveryHoursFrom();

    /**
     * @param string $deliveryHoursFrom
     * @return $this
     */
    public function setDeliveryHoursFrom($deliveryHoursFrom);

    /**
     * @return string|null
     */
    public function getDeliveryMinutesFrom();

    /**
     * @param string $deliveryMinutesFrom
     * @return $this
     */
    public function setDeliveryMinutesFrom($deliveryMinutesFrom);

    /**
     * @return string|null
     */
    public function getDeliveryHoursTo();

    /**
     * @param string $deliveryHoursTo
     * @return $this
     */
    public function setDeliveryHoursTo($deliveryHoursTo);

    /**
     * @return string|null
     */
    public function getDeliveryMinutesTo();

    /**
     * @param string $deliveryMinutesTo
     * @return $this
     */
    public function setDeliveryMinutesTo($deliveryMinutesTo);

    /**
     * @return string|null
     */
    public function getDeliveryComment();

    /**
     * @param string $deliveryComment
     * @return $this
     */
    public function setDeliveryComment($deliveryComment);

    /**
     * @return string|null
     */
    public function getDeliveryTime();

    /**
     * @param string $deliveryTime
     * @return $this
     */
    public function setDeliveryTime($deliveryTime);

    /**
     * @return string|null
     */
    public function getDeliveryOptionId();

    /**
     * @param string $deliveryOptionId
     * @return $this
     */
    public function setDeliveryOptionId($deliveryOptionId);

    /**
     * @return string|null
     */
    public function getQuoteAddressId();

    /**
     * @param string $quoteAddressId
     * @return $this
     */
    public function setQuoteAddressId($quoteAddressId);
}
