<?php
namespace MageWorx\DeliveryDate\Helper\Data;

/**
 * Proxy class for @see \MageWorx\DeliveryDate\Helper\Data
 */
class Proxy extends \MageWorx\DeliveryDate\Helper\Data implements \Magento\Framework\ObjectManager\NoninterceptableInterface
{
    /**
     * Object Manager instance
     *
     * @var \Magento\Framework\ObjectManagerInterface
     */
    protected $_objectManager = null;

    /**
     * Proxied instance name
     *
     * @var string
     */
    protected $_instanceName = null;

    /**
     * Proxied instance
     *
     * @var \MageWorx\DeliveryDate\Helper\Data
     */
    protected $_subject = null;

    /**
     * Instance shareability flag
     *
     * @var bool
     */
    protected $_isShared = null;

    /**
     * Proxy constructor
     *
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     * @param string $instanceName
     * @param bool $shared
     */
    public function __construct(\Magento\Framework\ObjectManagerInterface $objectManager, $instanceName = '\\MageWorx\\DeliveryDate\\Helper\\Data', $shared = true)
    {
        $this->_objectManager = $objectManager;
        $this->_instanceName = $instanceName;
        $this->_isShared = $shared;
    }

    /**
     * @return array
     */
    public function __sleep()
    {
        return ['_subject', '_isShared', '_instanceName'];
    }

    /**
     * Retrieve ObjectManager from global scope
     */
    public function __wakeup()
    {
        $this->_objectManager = \Magento\Framework\App\ObjectManager::getInstance();
    }

    /**
     * Clone proxied instance
     */
    public function __clone()
    {
        if ($this->_subject) {
            $this->_subject = clone $this->_getSubject();
        }
    }

    /**
     * Debug proxied instance
     */
    public function __debugInfo()
    {
        return ['i' => $this->_subject];
    }

    /**
     * Get proxied instance
     *
     * @return \MageWorx\DeliveryDate\Helper\Data
     */
    protected function _getSubject()
    {
        if (!$this->_subject) {
            $this->_subject = true === $this->_isShared
                ? $this->_objectManager->get($this->_instanceName)
                : $this->_objectManager->create($this->_instanceName);
        }
        return $this->_subject;
    }

    /**
     * {@inheritdoc}
     */
    public function getChangeDateByCustomerEnabled(?int $storeId = null) : bool
    {
        return $this->_getSubject()->getChangeDateByCustomerEnabled($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getDisplayDatesWithExtraCharge(?int $storeId = null) : bool
    {
        return $this->_getSubject()->getDisplayDatesWithExtraCharge($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function isEnabled(?int $storeId = null) : bool
    {
        return $this->_getSubject()->isEnabled($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function isDefaultDeliveryDateEmailOutputEnabled(?int $storeId = null) : bool
    {
        return $this->_getSubject()->isDefaultDeliveryDateEmailOutputEnabled($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getQuoteLimitationMode(?int $storeId = null) : int
    {
        return $this->_getSubject()->getQuoteLimitationMode($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function includeDeliveryDatesReservedByUnaccomplishedOrders(?int $storeId = null) : bool
    {
        return $this->_getSubject()->includeDeliveryDatesReservedByUnaccomplishedOrders($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getTemplateDataForDeliveryDateInput(?int $storeId = null) : array
    {
        return $this->_getSubject()->getTemplateDataForDeliveryDateInput($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getCalendarDayPlaceholder(?int $storeId = null) : ?string
    {
        return $this->_getSubject()->getCalendarDayPlaceholder($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getTemplateDataForDeliveryTimeInput(?int $storeId = null) : array
    {
        return $this->_getSubject()->getTemplateDataForDeliveryTimeInput($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getDeliveryTimeFormattedMessage($from = null, $to = null, ?int $storeId = null) : ?string
    {
        return $this->_getSubject()->getDeliveryTimeFormattedMessage($from, $to, $storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function formatTimeAccordingTimeTemplate($from = null, $to = null, ?int $storeId = null) : ?string
    {
        return $this->_getSubject()->formatTimeAccordingTimeTemplate($from, $to, $storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function parseDeliveryDateArray(\Magento\Framework\Api\ExtensionAttributesInterface $shippingAddressExtensionAttributes) : ?array
    {
        return $this->_getSubject()->parseDeliveryDateArray($shippingAddressExtensionAttributes);
    }

    /**
     * {@inheritdoc}
     */
    public function parseFromToPartsFromTimeLimitTemplate(array $timeLimitTemplate) : array
    {
        return $this->_getSubject()->parseFromToPartsFromTimeLimitTemplate($timeLimitTemplate);
    }

    /**
     * {@inheritdoc}
     */
    public function parseFromToPartsFromTimeString(string $timeString) : array
    {
        return $this->_getSubject()->parseFromToPartsFromTimeString($timeString);
    }

    /**
     * {@inheritdoc}
     */
    public function getTimeLabelFormat(?int $storeId = null) : ?string
    {
        return $this->_getSubject()->getTimeLabelFormat($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function isGeneralQueueUsed(?int $storeId = null) : bool
    {
        return $this->_getSubject()->isGeneralQueueUsed($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function isCommentFieldVisible(?int $storeId = null) : bool
    {
        return $this->_getSubject()->isCommentFieldVisible($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getCommentFieldLabel(?int $storeId = null) : ?string
    {
        return $this->_getSubject()->getCommentFieldLabel($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getDateFormat(?int $storeId = null) : ?string
    {
        return $this->_getSubject()->getDateFormat($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function formatDateFromDefaultToStoreSpecific($date, ?int $storeId = null) : string
    {
        return $this->_getSubject()->formatDateFromDefaultToStoreSpecific($date, $storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getWorkingDaysSourceModel() : \MageWorx\DeliveryDate\Model\Source\WorkingDays
    {
        return $this->_getSubject()->getWorkingDaysSourceModel();
    }

    /**
     * {@inheritdoc}
     */
    public function isNeedToReplaceDateToWords(?int $storeId = null) : bool
    {
        return $this->_getSubject()->isNeedToReplaceDateToWords($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getDefaultDeliveryOptionId() : int
    {
        return $this->_getSubject()->getDefaultDeliveryOptionId();
    }

    /**
     * {@inheritdoc}
     */
    public function isDeliveryDateRequired(?int $storeId = null) : bool
    {
        return $this->_getSubject()->isDeliveryDateRequired($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function isPreSelectDeliveryDateEnabled(?int $storeId = null) : bool
    {
        return $this->_getSubject()->isPreSelectDeliveryDateEnabled($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getPart($data, $i) : ?int
    {
        return $this->_getSubject()->getPart($data, $i);
    }

    /**
     * {@inheritdoc}
     */
    public function getDeliveryDateTitle(?int $storeId = null) : ?string
    {
        return $this->_getSubject()->getDeliveryDateTitle($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getDeliveryTimeTitle(?int $storeId = null) : ?string
    {
        return $this->_getSubject()->getDeliveryTimeTitle($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function convertBaseAmountToStoreCurrencyAmount($amount, $format = false)
    {
        return $this->_getSubject()->convertBaseAmountToStoreCurrencyAmount($amount, $format);
    }

    /**
     * {@inheritdoc}
     */
    public function getUseProductMinDeliveryDays(?int $storeId = null) : bool
    {
        return $this->_getSubject()->getUseProductMinDeliveryDays($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function isBlockIfOnAnyProductDisabledEDT(?int $storeId = null) : bool
    {
        return $this->_getSubject()->isBlockIfOnAnyProductDisabledEDT($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getProductEDTMessageFormat(?int $storeId = null) : ?string
    {
        return $this->_getSubject()->getProductEDTMessageFormat($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getProductSameDayDeliveryMessage($storeId = null) : ?string
    {
        return $this->_getSubject()->getProductSameDayDeliveryMessage($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getProductNextDayDeliveryMessage($storeId = null) : ?string
    {
        return $this->_getSubject()->getProductNextDayDeliveryMessage($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function useCalendarDaysOffset($storeId = null) : bool
    {
        return $this->_getSubject()->useCalendarDaysOffset($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function isEmptyDeliveryDateBlockVisible(?int $storeId = null) : bool
    {
        return $this->_getSubject()->isEmptyDeliveryDateBlockVisible($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function isUseStock(?int $storeId = null) : bool
    {
        return $this->_getSubject()->isUseStock($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getDeliveryDateProductErrorMessage(?int $storeId = null) : ?string
    {
        return $this->_getSubject()->getDeliveryDateProductErrorMessage($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function isSelectProductOptionsMessageVisible(?int $storeId = null) : bool
    {
        return $this->_getSubject()->isSelectProductOptionsMessageVisible($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getSelectProductOptionsMessage(?int $storeId = null) : ?string
    {
        return $this->_getSubject()->getSelectProductOptionsMessage($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function isErrorMessageVisibleOnProduct(?int $storeId = null) : bool
    {
        return $this->_getSubject()->isErrorMessageVisibleOnProduct($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function isNeedToSetDefaultDeliveryDate(?int $storeId = null) : bool
    {
        return $this->_getSubject()->isNeedToSetDefaultDeliveryDate($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function includeNonWorkingDaysInProcessingOrderPeriod(?int $storeId = null) : bool
    {
        return $this->_getSubject()->includeNonWorkingDaysInProcessingOrderPeriod($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getFirstDayIndex(?int $storeId = null) : int
    {
        return $this->_getSubject()->getFirstDayIndex($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function useEstimatedDeliveryPeriodToAsLimit(?int $storeId = null) : bool
    {
        return $this->_getSubject()->useEstimatedDeliveryPeriodToAsLimit($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getTimeStingFromDeliveryDataObject(\MageWorx\DeliveryDate\Api\Data\DeliveryDateDataInterface $deliveryDateData) : string
    {
        return $this->_getSubject()->getTimeStingFromDeliveryDataObject($deliveryDateData);
    }

    /**
     * {@inheritdoc}
     */
    public function isModuleOutputEnabled($moduleName = null)
    {
        return $this->_getSubject()->isModuleOutputEnabled($moduleName);
    }
}
