<?php
namespace WeltPixel\InstagramWidget\Block\Adminhtml\System\Config;

use Magento\Config\Block\System\Config\Form\Field;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\Data\Form\Element\AbstractElement;

class ClearCache extends Field
{
    /**
     * @var string
     */
    protected $_template = 'WeltPixel_InstagramWidget::system/config/clear_cache.phtml';

    /**
     * @param Context $context
     * @param array $data
     */
    public function __construct(
        Context $context,
        array $data = []
    ) {
        parent::__construct($context, $data);
    }

    /**
     * Remove scope label
     *
     * @param  AbstractElement $element
     * @return string
     */
    public function render(AbstractElement $element)
    {
        $element->unsScope()->unsCanUseWebsiteValue()->unsCanUseDefaultValue();
        return parent::render($element);
    }

    /**
     * Return element html
     *
     * @param  AbstractElement $element
     * @return string
     */
    protected function _getElementHtml(AbstractElement $element)
    {
        return $this->_toHtml();
    }

    /**
     * Return ajax url for clear cache button
     *
     * @return string
     */
    public function getAjaxUrl()
    {
        return $this->getUrl('weltpixel_instagram/system_config/clearCache');
    }

    /**
     * Generate button html
     *
     * @return string
     */
    public function getButtonHtml()
    {
        $button = $this->getLayout()->createBlock(
            \Magento\Backend\Block\Widget\Button::class
        )->setData(
            [
                'id' => 'clear_cache_button',
                'label' => __('Clear Cache'),
                'class' => 'primary'
            ]
        );

        return $button->toHtml();
    }
} 