<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Controller\Adminhtml\ImportExport;

use Exception;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\App\Response\Http\FileFactory;
use Magento\Framework\App\ResponseInterface;
use MageWorx\ShippingRules\Api\ExportHandlerInterfaceFactory;
use MageWorx\ShippingRules\Model\ImportExport\ExpressExportHandler;
use MageWorx\ShippingRules\Model\ImportExport\ExpressExportHandlerFactory;

class ExpressExportPost extends Action
{
    /**
     * Authorization level of a basic admin session
     *
     * @see _isAllowed()
     */
    public const ADMIN_RESOURCE = 'MageWorx_ShippingRules::import_export';

    /**
     * Menu id
     */
    public const MENU_IDENTIFIER = 'MageWorx_ShippingRules::system_import_export';

    /**
     * @var FileFactory
     */
    protected $fileFactory;

    /**
     * @var ExportHandlerInterfaceFactory
     */
    protected $exportHandlerFactory;

    /**
     * @param Context $context
     * @param FileFactory $fileFactory
     * @param ExpressExportHandlerFactory $exportHandlerFactory
     */
    public function __construct(
        Context                     $context,
        FileFactory                 $fileFactory,
        ExpressExportHandlerFactory $exportHandlerFactory
    ) {
        $this->fileFactory          = $fileFactory;
        $this->exportHandlerFactory = $exportHandlerFactory;
        parent::__construct($context);
    }

    /**
     * Export action from import/export shipping carriers, methods and rates
     *
     * @return ResponseInterface
     * @throws Exception
     */
    public function execute()
    {
        /** @var ExpressExportHandler $exportHandler */
        $exportHandler = $this->exportHandlerFactory->create();
        $content       = $exportHandler->getContent();

        return $this->fileFactory->create(
            'carriers_methods_rates_' . date('Y-m-d') . '_' . time() . '.csv',
            $content,
            DirectoryList::VAR_DIR
        );
    }
}
