<?php

namespace BG\DesignHuddle\Model;

use \BG\DesignHuddle\Model\CustomDesignFactory;
use Psr\Log\LoggerInterface;
use BG\DesignHuddle\Helper\Data as Dhhelper;
use BG\DesignHuddle\Helper\Databgcollect as DatabgcollectHelper;



class PostManagement
{
    protected $CustomDesignModel;
    protected $_logger;
    protected $Dhhelper;
    protected $DatabgcollectHelper;
    public function __construct(
        CustomDesignFactory $CustomDesignModel,
        LoggerInterface $_logger,
        Dhhelper $Dhhelper,
        DatabgcollectHelper $DatabgcollectHelper
    ) {
        $this->_logger = $_logger;
        $this->CustomDesignModel = $CustomDesignModel;
        $this->Dhhelper = $Dhhelper;
        $this->DatabgcollectHelper = $DatabgcollectHelper;
    }

    /**
     * {@inheritdoc}
     */
    public function getPost($quote_id, $customer_id, $product_id, $item_id, $project_id, $sku, $access_key = null, $id = null)
    {
        $dhData = array();
        $dhData['order_id'] = '';
        $dhData['quote_id'] = $quote_id;
        $dhData['customer_id'] = $customer_id;


        $dhData['project_title'] = $sku;
        $dhData['product_id'] =  $product_id; //$quoteItemCollect->getProductId();
        $dhData['dh_project_id'] = $project_id;
        $dhData['dh_file'] = 'png';
        $dhData['dh_template_id'] = '';
        $dhData['product_img'] = '';
        $dhData['order_status'] = '0';
        $dhData['item_id'] = $item_id;

        $jobId = $this->Dhhelper->genrateJobId($project_id, 'pdf');
        $dhData['project_job_id'] = $jobId;

        $rawResponse = $this->Dhhelper->exportDesignHuddleFileData($project_id, $access_key);

        // $this->_logger->info('-----------------------------------------');
        // $this->_logger->info($rawResponse);
        // $this->_logger->info('-----------------------------------------');
        $huddleResponse = json_decode($rawResponse);
        // $this->_logger->info(json_encode($huddleResponse));
        // $this->_logger->info('-----------------------------------------Thumbnnail--------');
        // $this->_logger->info($huddleResponse->data->thumbnail_url);

        // $huddleResponse = json_decode($this->Databgcol->getDesignHuddleFile($projectId,$filetype));
        if ($huddleResponse->data->thumbnail_url) {
            $dhData['dh_file_path'] = $huddleResponse->data->thumbnail_url;
            $this->_logger->info('dh_file_path: ' . $dhData['dh_file_path']);
            $this->Dhhelper->saveDesignHudFile($huddleResponse->data->thumbnail_url, $project_id);
        } else {
            $dhData['dh_file_path'] = '';
            $this->_logger->info('dh_file_path is empty'); // Log if the value is empty
        }
        
        $bgCollection = $this->DatabgcollectHelper->getBgCollectionByQuoteId($quote_id,$product_id);
        $bgCollection->setOrder('id', 'DESC');
        $bgCollection->setPageSize(1);
        $customDesignObject = $bgCollection->getFirstItem();

        if($customDesignObject->getId()){ $id = $customDesignObject->getId(); }

        if ($id) {
            // Load the existing model by ID
            $model = $this->CustomDesignModel->create()->load($id);
            if (!$model->getId()) {
                return 'Error: No record found with ID ' . $id;
            }
            // Merge data carefully
            $model->addData($dhData);
           
        } else {
            // Create a new model if no ID is provided
            $model = $this->CustomDesignModel->create();
            $model->setData($dhData);
        }
        // Set the data and save the model
        $model->save();
        $message = 'Custom Design ' . ($id ? 'Updated' : 'Saved') . ' Successfully. Id: ' . $model->getId();
        $customData = [
            'message' => $message,
            'id' => $model->getId(),
            'dh_file_path' => $dhData['dh_file_path']
        ];

        // dh_project_id
        return json_encode($customData);
    }
}
