<?php
namespace BG\DesignHuddle\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\RedirectFactory;
use Magento\Framework\View\Result\PageFactory;
use Magento\Catalog\Api\ProductRepositoryInterface;

class Project extends Action
{
    protected $resultRedirectFactory;
    protected $resultPageFactory;
    protected $customerSession;
    protected $productRepository;
    protected $huddleHelper;

    public function __construct(
        Context $context,
        RedirectFactory $resultRedirectFactory,
        PageFactory $resultPageFactory,
        \BG\DesignHuddle\Helper\Data $huddleHelper,
        \Magento\Customer\Model\SessionFactory $customerSession,
        ProductRepositoryInterface $productRepository
    ) {
        parent::__construct($context);
        $this->resultRedirectFactory = $resultRedirectFactory;
        $this->resultPageFactory = $resultPageFactory;
        $this->huddleHelper = $huddleHelper;
        $this->customerSession = $customerSession;
        $this->productRepository = $productRepository;
    }

    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        $resultPage = $this->resultPageFactory->create();
        $projectId = $this->getRequest()->getParam('id');
        $projectJobId = $this->getRequest()->getParam('job');
        try {
            
            if($projectId && $projectJobId){
                $huddleData = $this->huddleHelper->exportDesignHuddleFileEmail($projectId, $projectJobId, 'pdf');
                /*echo "<pre>";
                	print_r($huddleData);
                echo "</pre>";
                die();*/
                $imageThumbnailUrl = $progressPercentage = null;
                if($huddleData){
                    if(isset($huddleData->data->completed)){
                        if($huddleData->data->completed == 1){
                            $imageThumbnailUrl = $huddleData->data->thumbnail_url;
                            // for testing
                            /*$block = $resultPage->getLayout()->getBlock('huddle_project_status');
                            if ($block) {
                                $block->setData('progress_percentage', 20);
                            }
                            return $resultPage;*/
                        }else{
                            if(isset($huddleData->data->progress_percentage)){
                                $progressPercentage = $huddleData->data->progress_percentage;
                            }
                        }
                    }else{
                        if(isset($huddleData->data->progress_percentage)){
                            $progressPercentage = $huddleData->data->progress_percentage;
                        }
                    }

                    if($progressPercentage){
                        $block = $resultPage->getLayout()->getBlock('huddle_project_status');
                        if ($block) {
                            $block->setData('progress_percentage', $progressPercentage);
                        }
                        return $resultPage;

                    }else{
                        //$resultRedirect->setUrl($imageThumbnailUrl);
                        $block = $resultPage->getLayout()->getBlock('huddle_project_status');
                        if ($block) {
                            $block->setData('image_thumbnail_url', $imageThumbnailUrl);
                            $block->setData('project_id', $projectId);
                            $block->setData('project_job_id', $projectJobId);
                        }
                        return $resultPage;
                    }
                }else{
                	$resultRedirect->setPath('/');
                }
            }else{
                $resultRedirect->setPath('/');
            }

        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage($e->getMessage());
        }
        
        return $resultRedirect;
    }
}
