<?php
namespace WeltPixel\GA4\Controller\Track;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;

class Hyva extends Action
{
    /**
     * @var \WeltPixel\GA4\Helper\Data
     */
    protected $ga4Helper;

    /**
     * @var \Magento\Checkout\Model\Session
     */
    protected $checkoutSession;

    /**
     * @var \Magento\Payment\Helper\Data
     */
    protected $paymentHelper;

    /**
     * @param Context $context
     * @param \WeltPixel\GA4\Helper\Data $ga4Helper
     * @param \Magento\Checkout\Model\Session $checkoutSession
     * @param \Magento\Payment\Helper\Data $paymentHelper
     */
    public function __construct(
        Context $context,
        \WeltPixel\GA4\Helper\Data $ga4Helper,
        \Magento\Checkout\Model\Session $checkoutSession,
        \Magento\Payment\Helper\Data $paymentHelper
    ) {
        parent::__construct($context);
        $this->ga4Helper = $ga4Helper;
        $this->checkoutSession = $checkoutSession;
        $this->paymentHelper = $paymentHelper;
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface|string
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function execute()
    {
        $step = $this->getRequest()->getPostValue('step');
        $option = $this->getRequest()->getPostValue('option');

        if (!$step || !$option) {
            return $this->prepareResult('');
        }

        $quote = $this->checkoutSession->getQuote();

        if (!$quote) {
            return $this->prepareResult('');
        }

        switch ($step) {
            case '1' :
                $shippingDescription = $quote->getShippingAddress()->getShippingDescription();
                $dataLayer = $this->ga4Helper->addCheckoutStepPushData('1', $shippingDescription);
                break;
            case '2' :
                $paymentCode = $quote->getPayment()->getMethod();
                $allPaymentMethodsArray = $this->paymentHelper->getPaymentMethodList();
                if (isset($allPaymentMethodsArray[$paymentCode])) {
                    $paymentMethodTitle = $allPaymentMethodsArray[$paymentCode];
                    $dataLayer = $this->ga4Helper->addCheckoutStepPushData('2', $paymentMethodTitle);
                }
                break;
        }

        if (isset($dataLayer[0])) {
            return $this->prepareResult($dataLayer[0]);
        }

        return $this->prepareResult('');
    }

    /**
     * @param array $result
     * @return string
     */
    protected function prepareResult($result)
    {
        $jsonData = json_encode($result);
        $this->getResponse()->setHeader('Content-type', 'application/json');
        $this->getResponse()->setBody($jsonData);
    }
}
