<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

declare(strict_types=1);

namespace MageWorx\Downloads\Ui\Component\Listing\Column;

class SectionActions extends \Magento\Ui\Component\Listing\Columns\Column
{
    /**
     * Url path  to edit
     *
     * @var string
     */
    public const URL_PATH_EDIT = 'mageworx_downloads/section/edit';

    /**
     * Url path  to delete
     *
     * @var string
     */
    public const URL_PATH_DELETE = 'mageworx_downloads/section/delete';

    /**
     * URL builder
     *
     * @var \Magento\Framework\UrlInterface
     */
    protected $urlBuilder;

    /**
     * Constructor
     *
     * @param \Magento\Framework\UrlInterface $urlBuilder
     * @param \Magento\Framework\View\Element\UiComponent\ContextInterface $context
     * @param \Magento\Framework\View\Element\UiComponentFactory $uiComponentFactory
     * @param array $components
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\UrlInterface $urlBuilder,
        \Magento\Framework\View\Element\UiComponent\ContextInterface $context,
        \Magento\Framework\View\Element\UiComponentFactory $uiComponentFactory,
        array $components = [],
        array $data = []
    ) {

        $this->urlBuilder = $urlBuilder;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }


    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (!isset($dataSource['data']['items'])) {
            return $dataSource;
        }

        foreach ($dataSource['data']['items'] as & $item) {

            if (!isset($item['section_id'])) {
                continue;
            }

            $item[$this->getData('name')] = [
                'edit'   => [
                    'href'  => $this->urlBuilder->getUrl(
                        static::URL_PATH_EDIT,
                        [
                            'section_id' => $item['section_id']
                        ]
                    ),
                    'label' => __('Edit')
                ],
                'delete' => [
                    'href'    => $this->urlBuilder->getUrl(
                        static::URL_PATH_DELETE,
                        [
                            'section_id' => $item['section_id']
                        ]
                    ),
                    'label'   => __('Delete'),
                    'confirm' => [
                        'title'         => __('Delete "${ $.$data.name }"'),
                        'message'       => __('Are you sure you want to delete the Section "${ $.$data.name }" ?'),
                        '__disableTmpl' => ['title' => false, 'message' => false]
                    ]
                ]
            ];
        }

        return $dataSource;
    }
}
