<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */



namespace Anowave\Ec\Model\Config\Backend;

use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Config\Model\Config\Backend\File;


class Key extends File
{
    const UPLOAD_DIR = 'ec';

    /**
     * Return path to directory for upload file
     *
     * @return string
     * @throws LocalizedException
     */

    protected function _getUploadDir()
    {
        return $this->_filesystem->getDirectoryWrite(DirectoryList::VAR_DIR)->getAbsolutePath(static::UPLOAD_DIR);
    }
    /**
	 * Get allowed extensions
	 * 
     * @return array
     */
    public function getAllowedExtensions() : array
	{
        return ['json'];
    }
}