<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Controller\Adminhtml\Analytics;

use Magento\Backend\App\Action\Context;
use Magento\Backend\Controller\Adminhtml\Dashboard;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\Controller\Result\Raw;
use Magento\Framework\Controller\Result\RawFactory;
use Magento\Framework\View\LayoutFactory;
use Magento\Framework\View\Element\Template;
use Anowave\Ec\Model\Ads as AdsApi;

class Ads extends Dashboard implements HttpPostActionInterface
{
    /**
     * @var RawFactory
     */
    protected $resultRawFactory;

    /**
     * @var LayoutFactory
     */
    protected $layoutFactory;

    /**
     * @var AdsApi;
     */
    protected $ads;

    /**
     * @param Context $context
     * @param RawFactory $resultRawFactory
     * @param LayoutFactory $layoutFactory
     */
    public function __construct
    (
        Context $context,
        RawFactory $resultRawFactory,
        LayoutFactory $layoutFactory,
        AdsApi $ads
    ) 
    {
        parent::__construct($context);

        $this->resultRawFactory = $resultRawFactory;
        $this->layoutFactory = $layoutFactory;
        $this->ads = $ads;
    }

    /**
     * Retrieve block content via ajax
     *
     * @return Raw
     */
    public function execute()
    {
        /** 
         * @var Raw $resultRaw 
         **/
        $resultRaw = $this->resultRawFactory->create();

        if ($this->ads->isConfigured())
        {
            $content = $this->layoutFactory->create()->createBlock(Template::class)->setTemplate('Anowave_Ec::health.phtml')->setData
            (
                [
                    'health' => $this->ads->getHealth()
                ]
            )->toHtml();
        }
        else 
        {
            $content = __('Google Ads API is not configured yet.');
        }

        
        return $resultRaw->setContents($content);
    }
}