<?php
namespace WeltPixel\OwlCarouselSlider\Plugin\MediaStorage;

class UploaderPlugin
{
    /**
     * Modify validation to allow webp
     *
     * @param \Magento\MediaStorage\Model\File\Uploader $subject
     * @param callable $proceed
     * @param string $filePath
     * @return bool
     */
    public function aroundCheckAllowedExtension(
        \Magento\MediaStorage\Model\File\Uploader $subject,
        callable $proceed,
        $filePath
    ) {
        $extension = pathinfo($filePath, PATHINFO_EXTENSION);
        if (strtolower($extension) === 'webp') {
            if (!file_exists($filePath)) {
                return false;
            }
            $imageInfo = getimagesize($filePath);
            return $imageInfo !== false;
        }
        return $proceed($filePath);
    }

    /**
     * Before save, ensure proper handling of WebP
     *
     * @param \Magento\MediaStorage\Model\File\Uploader $subject
     * @param array $result
     * @return array
     */
    public function afterSave(
        \Magento\MediaStorage\Model\File\Uploader $subject,
        $result
    ) {
        if (is_array($result) && isset($result['path']) && isset($result['file'])) {
            $filePath = $result['path'] . $result['file'];
            if (pathinfo($filePath, PATHINFO_EXTENSION) === 'webp') {
                // Ensure the file exists and is readable
                if (!is_readable($filePath)) {
                    throw new \Exception('Unable to read uploaded WebP file.');
                }
            }
        }
        return $result;
    }
}
