<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Ui\DataProvider\Region\Form\Modifier;

use Magento\Framework\App\RequestInterface;
use Magento\Framework\Registry;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\Framework\UrlInterface;
use Magento\Store\Model\StoreManagerInterface;
use MageWorx\ShippingRules\Model\RegionFactory;

/**
 * Data provider for main panel
 */
class General extends AbstractModifier
{
    public const KEY_SUBMIT_URL        = 'submit_url';
    public const GENERAL_FIELDSET_NAME = 'general';

    /**
     * @var array
     */
    protected $meta = [];

    /**
     * @var RequestInterface
     */
    protected $request;

    /**
     * @param ArrayManager $arrayManager
     * @param UrlInterface $urlBuilder
     * @param RegionFactory $regionFactory
     * @param Registry $coreRegistry
     * @param StoreManagerInterface $storeManager
     * @param RequestInterface $request
     */
    public function __construct(
        ArrayManager          $arrayManager,
        UrlInterface          $urlBuilder,
        RegionFactory         $regionFactory,
        Registry              $coreRegistry,
        StoreManagerInterface $storeManager,
        RequestInterface      $request
    ) {
        parent::__construct($arrayManager, $urlBuilder, $regionFactory, $coreRegistry, $storeManager);
        $this->request = $request;
    }

    /** {@inheritdoc} */
    public function modifyData(array $data)
    {
        // Add submit (save) url to the config
        $actionParameters = [];
        $submitUrl        = $this->urlBuilder->getUrl(
            'mageworx_shippingrules/shippingrules_region/save',
            $actionParameters
        );
        $data             = array_replace_recursive(
            $data,
            [
                'config' => [
                    self::KEY_SUBMIT_URL => $submitUrl,
                ]
            ]
        );

        return $data;
    }

    /** {@inheritdoc} */
    public function modifyMeta(array $meta)
    {
        $this->meta = $meta;

        return $this->meta;
    }
}
