<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Controller\Adminhtml\Shippingrules;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Response\Http\FileFactory;
use Magento\Framework\Registry;
use Magento\Framework\Stdlib\DateTime\Filter\Date;
use MageWorx\ShippingRules\Api\RuleRepositoryInterface;
use Psr\Log\LoggerInterface;

/**
 * Class Quote
 */
abstract class Quote extends Action
{
    /**
     * Core registry
     *
     * @var Registry
     */
    protected $coreRegistry = null;

    /**
     * @var FileFactory
     */
    protected $fileFactory;

    /**
     * @var Date
     */
    protected $dateFilter;

    /**
     * @var RuleRepositoryInterface
     */
    protected $ruleRepository;

    /**
     * @var LoggerInterface
     */
    protected $logger;

    /**
     * @param Context $context
     * @param Registry $coreRegistry
     * @param FileFactory $fileFactory
     * @param Date $dateFilter
     * @param RuleRepositoryInterface $ruleRepository
     * @param LoggerInterface $logger
     */
    public function __construct(
        Context                 $context,
        Registry                $coreRegistry,
        FileFactory             $fileFactory,
        Date                    $dateFilter,
        RuleRepositoryInterface $ruleRepository,
        LoggerInterface         $logger
    ) {
        parent::__construct($context);
        $this->coreRegistry   = $coreRegistry;
        $this->fileFactory    = $fileFactory;
        $this->dateFilter     = $dateFilter;
        $this->ruleRepository = $ruleRepository;
        $this->logger         = $logger;
    }

    /**
     * Initiate rule
     *
     * @return void
     */
    protected function _initRule()
    {
        $id = (int)$this->getRequest()->getParam('id');
        if (!$id && $this->getRequest()->getParam('rule_id')) {
            $id = (int)$this->getRequest()->getParam('rule_id');
        }

        if ($id) {
            $rule = $this->ruleRepository->getById($id);
        } else {
            $rule = $this->ruleRepository->getEmptyEntity();
        }

        $this->coreRegistry->register(
            'current_promo_quote_rule',
            $rule
        );
    }

    /**
     * Initiate action
     *
     * @return Quote
     */
    protected function _initAction()
    {
        $this->_view->loadLayout();
        $this->_setActiveMenu('MageWorx_ShippingRules::shippingrules_quote')
             ->_addBreadcrumb(__('Shipping Rules'), __('Shipping Rules'));

        return $this;
    }

    /**
     * Returns result of current user permission check on resource and privilege
     *
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('MageWorx_ShippingRules::quote');
    }
}
