<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */
declare(strict_types=1);

namespace MageWorx\DynamicOptionsBase\Model\Source;

use MageWorx\DynamicOptionsBase\Model\Source;

class MeasurementUnits extends Source
{
    public const METER = 'meters';
    public const CENTIMETER = 'centimeters';
    public const FOOT       = 'feet';
    public const INCH = 'inches';
    public const MILLIMETER = 'millimeters';
    public const LITER      = 'liters';
    public const MILLILITER = 'milliliters';
    public const GALLON     = 'gallons';
    public const KILOGRAM = 'kilograms';
    public const GRAM     = 'grams';
    public const POUND = 'pounds';
    public const TON   = 'tons';
    public const OUNCE = 'ounces';

    public function toOptionArray(): array
    {
        return [
            ['value' => self::METER, 'label' => __('Meter')],
            ['value' => self::CENTIMETER, 'label' => __('Centimeter')],
            ['value' => self::MILLIMETER, 'label' => __('Millimeter')],
            ['value' => self::FOOT, 'label' => __('Foot')],
            ['value' => self::INCH, 'label' => __('Inch')],
            ['value' => self::LITER, 'label' => __('Liter')],
            ['value' => self::MILLILITER, 'label' => __('Milliliter')],
            ['value' => self::GALLON, 'label' => __('Gallon')],
            ['value' => self::GRAM, 'label' => __('Gram')],
            ['value' => self::KILOGRAM, 'label' => __('Kilogram')],
            ['value' => self::TON, 'label' => __('Ton')],
            ['value' => self::POUND, 'label' => __('Pound')],
            ['value' => self::OUNCE, 'label' => __('Ounce')]
        ];
    }
}
