<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Controller\Adminhtml\Ads;

use Magento\Backend\App\Action\Context;
use Magento\Backend\App\Action;
use Magento\Framework\Controller\Result\JsonFactory;
use Anowave\Ec\Model\Ads;
use Magento\Framework\View\Element\BlockFactory;

class Enhancement extends Action
{
    /**
     * @var \Magento\Framework\Controller\Result\JsonFactory
     */
    protected $jsonFactory;

    /**
     * @var Ads
     */
    protected $ads;

    /**
     * @var BlockFactory
     */
    protected $blockFactory;

    /**
     * Constructor 
     * 
     * @param Context $context
     * @param JsonFactory $jsonFactory
     */
    public function __construct
    (
        Context $context,
        JsonFactory $jsonFactory,
        Ads $ads,
        BlockFactory $blockFactory
    ) 
    {
        parent::__construct($context);
        
        /**
         * Set JSON factory 
         * 
         * @var JsonFactory $jsonFactory
         */
        $this->jsonFactory = $jsonFactory;
        $this->ads = $ads;
        $this->blockFactory = $blockFactory;
    }
    
	public function execute()
	{
	    $resultJson = $this->jsonFactory->create();

        $config = $this->getRequest()->getParam('config');

        if ($this->ads->isEligible((int) $config['order_id']))
        {
            $data = $this->ads->getFields((int) $config['order_id']);

            $content = $this->blockFactory->createBlock('Magento\Framework\View\Element\Template')->setTemplate('Anowave_Ec::enhancement.phtml')->setData($data)->toHtml();
    
        }
        else 
        {
            $content = __('Cannot continue. Google Ads API gives you the advantage of sending first-party conversion data within 24 hours of the conversion event.');
        }

	    return $resultJson->setData(
        [
            'content' => $content
        ]);
	}
}