<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Model;

use Magento\Backend\Model\Session\Quote;
use Magento\Checkout\Model\Session;
use Magento\Framework\App\Area;
use Magento\Framework\App\State;
use Magento\Framework\Exception\LocalizedException;
use MageWorx\ShippingRules\Api\QuoteSessionManagerInterface;

/**
 * Class QuoteSessionManager
 *
 * Detects actual session (frontend or backend)
 */
class QuoteSessionManager implements QuoteSessionManagerInterface
{
    /**
     * @var Session|Quote
     */
    protected $session;

    /**
     * QuoteSessionManager constructor.
     *
     * @param Session $checkoutSession
     * @param Quote $backendQuoteSession
     * @param State $appState
     * @throws LocalizedException
     */
    public function __construct(
        Session $checkoutSession,
        Quote   $backendQuoteSession,
        State   $appState
    ) {
        if ($appState->getAreaCode() == Area::AREA_ADMINHTML) {
            $this->session = $backendQuoteSession;
        } else {
            $this->session = $checkoutSession;
        }
    }

    /**
     * @return Session|Quote
     */
    public function getActualSession()
    {
        return $this->session;
    }
}
