<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\Downloads\Controller\Adminhtml\Attachment;

use Magento\Framework\Controller\Result\RawFactory as ResultRawFactory;
use MageWorx\Downloads\Model\Attachment\Link as AttachmentLink;
use MageWorx\Downloads\Model\Upload;

class Uploader extends \Magento\Backend\App\Action
{
    public const ADMIN_RESOURCE = 'MageWorx_Downloads::attachments';

    protected ResultRawFactory $resultRawFactory;
    protected Upload           $uploadModel;
    protected AttachmentLink   $fileLinkModel;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        ResultRawFactory                    $resultRawFactory,
        AttachmentLink                      $fileLinkModel,
        Upload                              $uploadModel
    ) {
        parent::__construct($context);
        $this->resultRawFactory = $resultRawFactory;
        $this->uploadModel      = $uploadModel;
        $this->fileLinkModel    = $fileLinkModel;
    }

    public function execute()
    {
        try {
            $file = $this->uploadModel
                ->uploadFileAndGetName('multifile', $this->fileLinkModel->getBaseDir(), []);

            $fileDataAfterUpload = $this->uploadModel->getFileDataAfterUpload();

            $result         = [];
            $result['file'] = $file;
            $result['url']  = $this->fileLinkModel->getBaseUrl() . $result['file'];
            $result['name'] = $fileDataAfterUpload['name'];
            $result['size'] = $fileDataAfterUpload['size'];

        } catch (\Exception $e) {
            $result = ['error' => $e->getMessage(), 'errorcode' => $e->getCode()];
        }

        $response = $this->resultRawFactory->create();
        $response->setHeader('Content-type', 'text/plain');
        $response->setContents(json_encode($result));

        return $response;
    }

    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('MageWorx_Downloads::attachments');
    }
}
