<?php
namespace BG\DesignHuddle\Controller\Proxy;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;

class Index extends Action
{
    protected $huddleHelper;

    public function __construct(
        Context $context,
        \BG\DesignHuddle\Helper\Data $huddleHelper
    ) {
        parent::__construct($context);
        $this->huddleHelper = $huddleHelper;
    }
    
    public function execute()
    {
        //$url = base64_decode($this->getRequest()->getParam('url'));
        $projectId = $this->getRequest()->getParam('project_id');
        $projectJobId = $this->getRequest()->getParam('project_job_id');
        $imageThumbnailUrl = null;
        if($projectId && $projectJobId){
	   $huddleData = $this->huddleHelper->exportDesignHuddleFileEmail($projectId, $projectJobId, 'pdf');
	   $imageThumbnailUrl = null;
	   if($huddleData){
	      if(isset($huddleData->data->completed)){
		 if($huddleData->data->completed == 1){
		    $imageThumbnailUrl = $huddleData->data->thumbnail_url;       
		 }
	      }
           }
	 }
        
        if (!$imageThumbnailUrl) {
            throw new \Exception('Missing URL');
        }

        $ch = curl_init($imageThumbnailUrl);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HEADER => false,
            CURLOPT_FOLLOWLOCATION => true,
        ]);

        $pdfData = curl_exec($ch);
        curl_close($ch);

        header('Content-Type: application/pdf');
        header('Content-Disposition: inline; filename="preview.pdf"');
        echo $pdfData;
        exit;
    }
}
