define(['underscore','Magento_Ui/js/modal/alert','jquery', 'Magento_Ui/js/modal/modal', 'mage/url', 'uiRegistry', 'Magento_Ui/js/modal/confirm'], function (underscore, alert, $, modal, url, registry, confirmation) 
{
    'use strict';

    return {
        addSvg: function()
        {
            return this;
        },
        enhancement: function(config)
        {
            let dialog = $('<div/>', { id: 'enhancement' }).appendTo(document.body), content = $('<div/>', { id: 'enhancement-content' }).html('Please wait...').appendTo(dialog);
                
            let self = this;

            let modal = dialog.modal(
            {
                title: 'Conversion Adjustment Enhancement',
                autoOpen: true,
                closed: function () {},
                buttons: 
                [
                    {
                        text: 'Apply',
                        click: function()
                        {
                            let context = this;

                            let form = new FormData(document.querySelector('form[data-enhancement]'));

                            let enhancement = {};

                            for (const [key, value] of form) 
                            {
                                enhancement[key] = value;
                            }

                            modal.modal('setTitle', 'Sending. Please wait...');

                            $.post(self.getUrl('track/ads/enhance'),  {form_key: FORM_KEY, order: config.order_id, enhancement: enhancement },  function(response)
                            {
                                alert(
                                {
                                    title:      response.alert.title,
                                    content:    response.alert.content,
                                    actions: 
                                    {
                                        always: function(){}
                                    }
                                });

                                context.closeModal();
                            });
                        },
                        'class': 'action-primary'
                    }
                 ]
            });

            modal.on('modalopened', (() => 
            {
                $.post(this.getUrl('track/ads/enhancement'),  {form_key: FORM_KEY, config: config },  function(response)
                {
                    content.empty().html(response.content);
                });

            }).apply(this));
  
            return this;
        },
        adjustment: function(config)
        {
            let dialog = $('<div/>', { id: 'adjustment' }).appendTo(document.body), content = $('<div/>', { id: 'adjustment-content' }).html('Please wait...').appendTo(dialog);
                
            let self = this;

            let modal = dialog.modal(
            {
                title: 'Conversion Adjustment',
                autoOpen: true,
                closed: function () {},
                buttons: 
                [
                    {
                        text: 'Apply',
                        click: function()
                        {
                            let context = this;

                            let form = new FormData(document.querySelector('form[data-adjustment]'));

                            let adjustment = {};

                            for (const [key, value] of form) 
                            {
                                adjustment[key] = value;
                            }

                            confirmation(
                            {
                                title: 'Are you sure?',
                                content: 'Do you want to send this conversion adjustment?',
                                actions: {
                    
                                    confirm: function () 
                                    {
                                        $.post(self.getUrl('track/ads/adjust'),  {form_key: FORM_KEY, order: config.order_id, adjustment: adjustment },  function(response)
                                        {
                                            alert(
                                            {
                                                title:      response.alert.title,
                                                content:    response.alert.content,
                                                actions: 
                                                {
                                                    always: function(){}
                                                }
                                            });

                                            context.closeModal();
                                        });    
                                    },
                    
                                    cancel: function () 
                                    {
                                        return false;
                                    }
                                }
                            });
                        },
                        'class': 'action-primary'
                    }
                 ]
            });

            modal.on('modalopened', (() => 
            {
                $.post(this.getUrl('track/ads/adjustment'),  {form_key: FORM_KEY, config: config },  function(response)
                {
                    content.empty().html(response.content);
                });

            }).apply(this));
  
            return this;
        },
        getUrl: function(route)
        {
            return '/' + url.build([(new URL(BASE_URL)).pathname.split('/').filter(String)[0], route].join('/'));
        },
        svg: function() 
        {
            let svg = this.node('svg', { width:40, height: 32, style:'cursor:pointer' });

            [
               this.node('path', { transform: 'translate(0 6) scale(0.7 0.7)', d: 'M26.153 11.46a6.888 6.888 0 0 0-.608-5.73 7.117 7.117 0 0 0-3.29-2.93 7.238 7.238 0 0 0-4.41-.454 7.065 7.065 0 0 0-2.41-1.742A7.15 7.15 0 0 0 12.514 0a7.216 7.216 0 0 0-4.217 1.346 7.061 7.061 0 0 0-2.603 3.539 7.12 7.12 0 0 0-2.734 1.188A7.012 7.012 0 0 0 .966 8.268a6.979 6.979 0 0 0 .88 8.273 6.89 6.89 0 0 0 .607 5.729 7.117 7.117 0 0 0 3.29 2.93 7.238 7.238 0 0 0 4.41.454 7.061 7.061 0 0 0 2.409 1.742c.92.404 1.916.61 2.923.604a7.215 7.215 0 0 0 4.22-1.345 7.06 7.06 0 0 0 2.605-3.543 7.116 7.116 0 0 0 2.734-1.187 7.01 7.01 0 0 0 1.993-2.196 6.978 6.978 0 0 0-.884-8.27Zm-10.61 14.71c-1.412 0-2.505-.428-3.46-1.215.043-.023.119-.064.168-.094l5.65-3.22a.911.911 0 0 0 .464-.793v-7.86l2.389 1.36a.087.087 0 0 1 .046.065v6.508c0 2.952-2.491 5.248-5.257 5.248ZM4.062 21.354a5.17 5.17 0 0 1-.635-3.516c.042.025.115.07.168.1l5.65 3.22a.928.928 0 0 0 .928 0l6.898-3.93v2.72a.083.083 0 0 1-.034.072l-5.711 3.255a5.386 5.386 0 0 1-4.035.522 5.315 5.315 0 0 1-3.23-2.443ZM2.573 9.184a5.283 5.283 0 0 1 2.768-2.301V13.515a.895.895 0 0 0 .464.793l6.897 3.93-2.388 1.36a.087.087 0 0 1-.08.008L4.52 16.349a5.262 5.262 0 0 1-2.475-3.185 5.192 5.192 0 0 1 .527-3.98Zm19.623 4.506-6.898-3.93 2.388-1.36a.087.087 0 0 1 .08-.008l5.713 3.255a5.28 5.28 0 0 1 2.054 2.118 5.19 5.19 0 0 1-.488 5.608 5.314 5.314 0 0 1-2.39 1.742v-6.633a.896.896 0 0 0-.459-.792Zm2.377-3.533a7.973 7.973 0 0 0-.168-.099l-5.65-3.22a.93.93 0 0 0-.928 0l-6.898 3.93V8.046a.083.083 0 0 1 .034-.072l5.712-3.251a5.375 5.375 0 0 1 5.698.241 5.262 5.262 0 0 1 1.865 2.28c.39.92.506 1.93.335 2.913ZM9.631 15.009l-2.39-1.36a.083.083 0 0 1-.046-.065V7.075c.001-.997.29-1.973.832-2.814a5.297 5.297 0 0 1 2.231-1.935 5.382 5.382 0 0 1 5.659.72 4.89 4.89 0 0 0-.168.093l-5.65 3.22a.913.913 0 0 0-.465.793l-.003 7.857Zm1.297-2.76L14 10.5l3.072 1.75v3.5L14 17.499l-3.072-1.75v-3.5Z', fill: '#db4891', style: 'cursor:pointer' })

            ].forEach(element => 
            {
                svg.appendChild(element);
            });

            [
                this.node('text', { x: 24, y:22, 'font-size':'18px', 'font-family':'Arial, sans-serif', fill: 'rgba(0,0,0,1)',style: 'cursor:pointer' })

            ].forEach(element => 
            {
                element.textContent = 'AI';

                svg.appendChild(element);
            });

            let wrapper = document.createElement('div');

            wrapper.appendChild(svg);

            return wrapper.innerHTML;
        },
        node: function(n, v) 
        {
            n = document.createElementNS("http://www.w3.org/2000/svg", n);
            
            for (var p in v) 
            {
                n.setAttributeNS(null, p, v[p]);
            }
            
            return n;
        }
    }
});