<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Ui\Component\Listing\Columns;

use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;
use MageWorx\ShippingRules\Helper\Data;
use MageWorx\ShippingRules\Model\Config\Source\Locale\AllRegions;

class RegionId extends Column
{
    /**
     * @var AllRegions
     */
    private $sourceRegions;

    /**
     * @var Data
     */
    private $helper;

    /**
     * @param ContextInterface $context
     * @param UiComponentFactory $uiComponentFactory
     * @param AllRegions $sourceRegions
     * @param mixed[] $components
     * @param mixed[] $data
     */
    public function __construct(
        ContextInterface   $context,
        UiComponentFactory $uiComponentFactory,
        AllRegions         $sourceRegions,
        Data               $helper,
        array              $components = [],
        array              $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);
        $this->sourceRegions = $sourceRegions;
        $this->helper        = $helper;
    }

    /**
     * Prepare Data Source
     *
     * @param mixed[] $dataSource
     * @return mixed[]
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                $item[$this->getData('name')] = $this->prepareItem($item);
            }
        }

        return $dataSource;
    }

    /**
     * Get data
     *
     * @param mixed[] $item
     * @return string
     */
    protected function prepareItem(array $item)
    {
        $content = '';
        if (!empty($item['region_id'])) {
            $origRegions = explode(',', (string)$item['region_id']);
        }

        if (empty($origRegions)) {
            return __('Any Region');
        }

        if (!is_array($origRegions)) {
            $origRegions = [$origRegions];
        }

        $data = $this->sourceRegions->toKeyValuePairs();

        $length            = 0;
        $maxRegionIdsCount = $this->helper->getMaxCountriesCount();
        foreach ($origRegions as $region) {
            if ($maxRegionIdsCount && $length >= $maxRegionIdsCount) {
                $regionsCount = count($origRegions);
                $content      .= __('... and %1 more regions.', $regionsCount - $length) . "<br/>";
                break;
            }

            if (empty($data[$region])) {
                continue;
            }

            $content .= $data[$region] . "<br/>";
            $length++;
        }

        return $content;
    }
}
